#include "util.h"

#include <cmath>
#include <cstdlib>
#include <cassert>

#include <boost/lexical_cast.hpp>

const Color Color::GRAY  (127, 127, 127);
const Color Color::WHITE (255, 255, 255);
const Color Color::BLACK (  0,   0,   0);
const Color Color::RED   (255,   0,   0);
const Color Color::ORANGE(255, 127,   0);
const Color Color::YELLOW(255, 255,   0);
const Color Color::GREEN (  0, 255,   0);
const Color Color::BLUE  (  0,   0, 255);
const Color Color::PURPLE(255,   0, 255);

void ignoreBrankAndComment(std::string& str, std::string delim) {
    unsigned int s;

    // Rg̏
    if ((s = str.find(delim)) != std::string::npos)
	str.erase(s);

    // s󔒂̏
    if (!str.empty() && str[0] == ' ')
	str.erase(0, str.find_first_not_of(' '));
}

double dtor(double x) { return x*PI/180; }
double rtod(double x) { return x*180/PI; }

Rect::Rect () {
}

Rect::Rect (const Rect& rhs) {
    val_.x = rhs.val_.x;
    val_.y = rhs.val_.y;
    val_.w = rhs.val_.w;
    val_.h = rhs.val_.h;
}

Rect::Rect (const int xs, const int ys, const int xe, const int ye,
	    const bool to) {
    val_.x = xs;
    val_.y = ys;

    // n_/I_̊֌WAn_/xNg̊֌W
    if (to) {
	val_.w = xe;
	val_.h = ye;
    }
    else {
	val_.w = xe - xs + 1;
	val_.h = ye - ys + 1;
    }    
}

Rect::Rect (const Point& ps, const Point& pe, const bool to) {
    *this = Rect(static_cast<int>(ps.x), static_cast<int>(ps.y),
		 static_cast<int>(pe.x), static_cast<int>(pe.y), to);
}

PolarCoord::PolarCoord() {}

PolarCoord::PolarCoord(const PolarCoord& rhs)
    : l(rhs.l), r(rhs.r) {}

PolarCoord::PolarCoord(double l0, double r0)
    : l(l0), r(r0) {}

PolarCoord::PolarCoord(const Point& rhs)
    : l(rhs.length()), r(rhs.angle()) {}

