/**
 * $Id: strutil.cc,v 1.3 2003/10/13 22:54:43 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "strutil.h"

#include <iostream>

std::string my_getline(std::istream& is) {
	std::string ret;
	int c;
	while (1) {
		if (is.eof()) return ret;
		c = is.get();
		if (c == '\r' || c == '\n') {
			if (is.eof()) return ret;
			c = is.get();
			if (c != '\r' && c != '\n') {
				is.unget();
			}
			break;
		}
		ret += c;
	}

	return ret;
}

std::string my_getline(FILE* fp) {
	std::string ret;
	int c;
	while (1) {
		c = std::fgetc(fp);
		if (c == EOF) return ret;
		else if (c == '\r' || c == '\n') {
			c = std::fgetc(fp);
			if (c != '\r' && c != '\n' && c != EOF) {
				std::ungetc(c, fp);
			}
			break;
		}
		ret += c;
	}

	return ret;
}

