#ifndef BOHA_SINGLETON
#define BOHA_SINGLETON

#include "cpputil.h"

// VOg̃x[X
template<class T>
class Singleton {
public:
	static T* instance();
	Singleton();
	virtual ~Singleton();

protected:
	static Singleton* instance_;
};

template<class T>
T* Singleton<T>::instance() {
	if (instance_ == 0) error("Singleton is'nt yet.\n");
	return dynamic_cast<T*>(instance_);
}

template<class T>
Singleton<T>* Singleton<T>::instance_ = 0;

template<class T>
Singleton<T>::Singleton() {
	check(instance_ == 0, "Singleton is made twice.\n");
	instance_ = this;
}

template<class T>
Singleton<T>::~Singleton() {
}

#endif // ! BOHA_SINGLETON
