#ifndef BOHA_WIN
#define BOHA_WIN

#include "config.h"
#include "util.h"
#include "singleton.h"
#include "config.h"

#include <SDL.h>

#include <cassert>

#include <string>
#include <iostream>
#include <utility>
#include <memory>

// Surface NX
class Surface {
public:
	explicit Surface(SDL_Surface* surf) : surf_(surf) {}
    explicit Surface(const std::string& str);
	Surface(const Surface& rhs);
	Surface(const Point& size, int bpp, Uint32 flag,
		   Uint32 Rmask =0, Uint32 Gmask =0, Uint32 Bmask =0, Uint32 Amask =0);
    Surface(int x, int y, int bpp, Uint32 flag,
		   Uint32 Rmask =0, Uint32 Gmask =0, Uint32 Bmask =0, Uint32 Amask =0);
	///  Surface B
	Surface(Surface& src, const Rect& rect);

    virtual ~Surface();

    void fillRect(const Rect& rect, int color) {
		int ret = SDL_FillRect(surf_, const_cast<SDL_Rect*>(rect.val()),
							   color);
		check(ret == 0, "Surface::fillRect");
    }
	void fillRect(const Rect& rect, Color col) {
		fillRect(rect, mapRGB(col));
	}
	void fill(int color) {
		int ret = SDL_FillRect(surf_, 0, color);
		check(ret == 0, "Surface::fillRect");
	}
	void fill(Color col) {
		fill(mapRGB(col));
	}

    void blit(Surface* src) {
		int ret = SDL_BlitSurface(src->surf_, 0, surf_, 0);
		check(ret == 0, "Surface::blit");
    }
    void blit(Surface* src, const Rect& srcrect, const Rect& dstrect) {
		int ret =
			SDL_BlitSurface(src->surf_, const_cast<SDL_Rect*>(srcrect.val()),
							surf_, const_cast<SDL_Rect*>(dstrect.val()));
		check(ret == 0, "Surface::blit");
    }
	void blit(Surface* src, const Point& pnt) {
		SDL_Rect dst;
		dst.x = pnt.xi();
		dst.y = pnt.yi();
		int ret =
			SDL_BlitSurface(src->surf_, 0, surf_, &dst);
		check(ret == 0, "Surface::blit");
	}

    void printInformation(std::ostream& os) const;

    virtual const Point& size() const { return size_; }

    void save(const std::string& filename) {
		SDL_SaveBMP(surf_, filename.c_str());
    }

	void setAlpha(Uint32 flag, Uint8 alpha) {
		int ret = SDL_SetAlpha(surf_, flag, alpha);
		check(ret == 0, "Surface::setAlpha");
	}

	void convertDisplayFormat();

    void setColorKey(Uint32 flag, Uint32 key) {
		int ret = SDL_SetColorKey(surf_, flag, key);
		check(ret == 0, "SurfacesetColorKey");
    }
	void setColorKey(Uint32 flag, Color col) {
		setColorKey(flag, mapRGB(col));
	}

	void setMask(Color col);

	double halfDiagonal() const { return halfDiagonal_; }
	const Point& halfSize() const { return halfSize_; }

	Uint32 getPixel(int x, int y);
	void putPixel(int x, int y, Uint32 pixel);

    Uint32 mapRGB(Color col) const {
		return col.map(surf_->format);
    }
	Color getRGB(Uint32 pixel) const {
		Uint8 r, g, b;
		SDL_GetRGB(pixel, surf_->format, &r, &g, &b);
		return Color(r, g, b);
	}

	void lock() {
		SDL_LockSurface(surf_);
	}
	void unlock() {
		SDL_UnlockSurface(surf_);
	}
	void update() {
		SDL_UpdateRect(surf_, 0, 0, 0, 0);
	}

    void putString(const std::string& str, const Point& pnt,
				   const Color& col = Color(0,0,0));
	int fontHeight();
	int fontWidth();
	int fontWidth(const std::string& str);

	// sge pN̂
	void drawHLine(Sint16 x1, Sint16 x2, Sint16 y, Color col);
	void drawVLine(Sint16 x, Sint16 y1, Sint16 y2, Color col);
	void drawLine(Sint16 x1, Sint16 y1, Sint16 x2, Sint16 y2, Color col);
	void drawRect(Sint16 x1, Sint16 y1, Sint16 x2, Sint16 y2, Color col);
	void drawRect(const Rect& r, Color col) {
		drawRect(r.x(), r.y(), r.x2(), r.y2(), col);
	}

	SDL_Surface* getSurface() { return surf_; }

protected:
	void calcCache();

protected:
	Surface() : surf_(0) {}

    SDL_Surface* surf_;
    Point size_;

	double halfDiagonal_;
	Point halfSize_;

};

#endif // BOHA_WIN
