#ifndef SGI_SELECT_H_
#define SGI_SELECT_H_

#include <functional>

/// this is sgi extension, but I think it should be standard.
namespace sgi {
	template <class _Pair>
	struct _Select1st :
		public std::unary_function<_Pair, typename _Pair::first_type>
	{
		const typename _Pair::first_type& operator()(const _Pair& __x) const {
			return __x.first;
		}
	};

	template <class _Pair>
	struct _Select2nd :
		public std::unary_function<_Pair, typename _Pair::second_type>
	{
		const typename _Pair::second_type& operator()(const _Pair& __x) const {
			return __x.second;
		}
	};

	template <class _Pair> struct select1st : public _Select1st<_Pair> {};
	template <class _Pair> struct select2nd : public _Select2nd<_Pair> {};

	/// I add helper functions...
}

#endif // ! SGI_SELECT_H_

