#ifndef BOHA_SELECT
#define BOHA_SELECT

#include <string>
#include <vector>
#include <memory>
#include <utility>

#include "util.h"
#include "mysdl_padinput.h"
#include "screen.h"
#include "surface.h"
#include "designer.h"

class BulletDescription;
class Designer;

class Select : private Designer {
public:
	Select() : temporaryUse_(true) {}
	explicit Select(MSDL::InputBase& input);

	int run();
	void fastRun();

	void putBulletInfo(BulletDescription* info);
	void putBulletInfo(size_t s);
	int putRanking();
	void insertRanking(int point, bool sp);
	int saveReplay();

	void setBulletMode() { state_ = BULLET; }

	void putStatusLine(const std::string& str);

	void setConf();
	void loadConf();

	void initBMP() { Designer::initBMP(); }

private:
	struct ConfigMenu {
		ConfigMenu(const std::string& filename);

		std::vector<std::string> title;
		std::vector<std::string> desc;
		std::vector<std::string> key;
		std::vector<std::string> value;
		std::vector<std::vector<std::string> > selects;
	};

private:
	typedef enum { ACT_UP, ACT_DOWN, ACT_RIGHT, ACT_LEFT,
				   ACT_DECISION, ACT_CANCEL, ACT_QUIT,
				   ACT_USR1, ACT_USR2, ACT_USR3} Action;
	Action selectAny(const std::vector<std::string>& strs,
					 const Point& pnt, int yspace,
					 size_t& index, size_t& scroll = zero, size_t cols = 99);

	Action selectConfigMenu(const std::string& str,
							Point pk, Point pv, Point pd, int yspace,
							const std::vector<std::string>& addstrs = nullvec);

	void inputName();
private:
	void selectTitle();
	void selectMode();
	void selectGroup();
	void selectBulletGroup();
	void selectBullet();
	void selectBulletDetail();
	void selectConfig();
	void selectReplay();

	void startReplay(const std::string& prefix);

	static void setInitialConf();

private:
	MSDL::InputBase* input_;

	typedef enum { TITLE, MODE, BULLET, BULLET_DETAIL, GROUP, BULLET_GROUP,
				   CONFIG, REPLAY, START_REPLAY, END, ESCAPE, QUIT } State;
	State state_, prevState_;

	typedef std::map<std::string, std::string> ConfMap;
	ConfMap conf_;

	typedef std::pair<std::string, int> RankElem;
	std::vector<RankElem> normalRanking_, spRanking_;

	int nowRank_, nowPoint_;

	// Ȋgc
	bool temporaryUse_;

private:
	static size_t zero;
	static std::vector<std::string> nullvec;
};

#endif // ! BOHA_SELECT
