#include "select.h"
#include "game.h"
#include "surface.h"
#include "loadconf.h"
#include "bulletinfo.h"
#include "conf.h"
#include "dir_ite.h"

#include <boost/lexical_cast.hpp>
#include <boost/functional.hpp>
#include <boost/ref.hpp>

#include <compose_ct.h>

#include <memory>
#include <algorithm>

// gcc ł isprint  std ȂBԂ}N̂B
// WێȒP gcc Œʂɂ c o[W
// #include ȂȂƎvB
#include <ctype.h>

size_t Select::zero = 0;
std::vector<std::string> Select::nullvec;

Select::Select(MSDL::InputBase& input)
	: input_(&input), state_(TITLE), temporaryUse_(false)
{
 	std::ifstream is("save/score.dat");
 	std::string s;
	int d;
	int i;
	for (i = 0; i < 10; i++) {
		is >> s >> d;
		normalRanking_.push_back(std::make_pair(s, d));
	}
	for (i = 0; i < 10; i++) {
		is >> s >> d;
		spRanking_.push_back(std::make_pair(s, d));
	}
}

void Select::setConf() {
	Conf* conf = Conf::instance();

	conf->normal_ = false;

	conf->replay_ = false;

	int mode = -1;
	if (!temporaryUse_) {
		mode = getSizeFromMap(conf_, "mode");
		conf->mode_ = mode;
	}

	std::string skin = getStringFromMap(conf_, "skin");
	if (skin != conf->skin_) {
		conf->skin_ = skin;
		Game::instance()->initBMP();
	}

	if (mode == 0 || mode == 1) conf->howToRun_ = Conf::SDMKUN;

	if ((mode == 2 || mode == 3) && state_ != MODE) {
		size_t bullet = getSizeFromMap(conf_, "bullet");
		if (bullet == 0) {
			conf->howToRun_ = Conf::SDMKUN;
			conf->normal_ = true;
			conf->title_ = "ZNg-C[h";
		}
		else {
			const std::vector<BulletDescription*>& desc =
				Game::instance()->getBulletInfo()->descriptions();

			if (bullet >= desc.size()) {
				bullet = desc.size()-1;
				conf_["bullet"] = boost::lexical_cast<std::string>(bullet);
			}

			conf->actionFile_ = desc[bullet]->xmlFile();
			conf->howToRun_ = Conf::XML;
			conf->title_ = desc[bullet]->title();
			Game::instance()->setNowBullet(desc[bullet]);
		}

		conf->sp_ = getBoolFromMap(conf_, "sp");

		if (conf->sp_) {
			conf->level_ = 0;
			conf->enemys_ = 1;
			conf->slow_ = 100;
			conf->isSlow_ = false;
			conf->density_ = 100;
			conf->playerSize_ = 2;
			conf->cpu_ = false;
			conf->title_ += "SP";
		}
		else {
			conf->level_ = getIntFromMap(conf_, "level");
			conf->enemys_ = getIntFromMap(conf_, "enemy_num");
			double speed = getDoubleFromMap(conf_, "speed");
			if (speed != 100) {
				conf->slow_ = speed / 100.0;
				conf->isSlow_ = true;
			}
			else {
				conf->isSlow_ = false;
			}
			conf->density_ = getIntFromMap(conf_, "bullet_density");
			conf->playerSize_ = getDoubleFromMap(conf_, "player_size");

			if (std::string("cpu") ==
				getStringFromMap(conf_, "player_input"))
			{
				conf->cpu_ = true;
			}
			else {
				conf->cpu_ = false;
			}
		}
	}

	std::string xy;
	xy	= getStringFromMap(conf_, "mini_display");
	if (xy.empty())	{
		conf->miniDispSize_ =
			Point(Screen::DEFAULT_MINI_X, Screen::DEFAULT_MINI_Y);
	}
	else {
		conf->miniDispSize_ = Point(xy);
	}
	xy	= getStringFromMap(conf_, "normal_display");
	if (xy.empty())	{
		conf->normalDispSize_ =
			Point(Screen::DEFAULT_NORMAL_X, Screen::DEFAULT_NORMAL_Y);
	}
	else {
		conf->normalDispSize_ = Point(xy);
	}
	conf->fps_ = getIntFromMap(conf_, "fps");
	conf->fullScreen_ = getBoolFromMap(conf_, "full_screen");
	conf->dimmed_ = getBoolFromMap(conf_, "string_dimmed");
	conf->english_ = getBoolFromMap(conf_, "english");
	conf->preloadShots_ = getBoolFromMap(conf_, "preload_shots");
	conf->playerSpeed_ = getIntFromMap(conf_, "player_speed") * 1.5;
	conf->playerSpeed2_ = getIntFromMap(conf_, "player_speed2") * 1.5;

	if (mode == -1) {
		if (getBoolFromMap(conf_, "fix_large")) {
			Game::instance()->switchScreenMode(true);

			putInfoFrames();
			const Rect& r = Screen::MAIN_FRAME;
			putDimmedRect(
				r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);
		}
		else {
			Game::instance()->switchScreenMode(false);
		}
	}
	else {
		if (getBoolFromMap(conf_, "fix_large")) {
			if (!Game::instance()->screenIsLarge()) {
				Game::instance()->switchScreenMode(true);

				putInfoFrames();
				const Rect& r = Screen::MAIN_FRAME;
				putDimmedRect(
					r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);
			}
		}
		else {
			if (state_ == MODE || state_ == CONFIG || state_ == ESCAPE) {
				Game::instance()->switchScreenMode(false);
			}
			else if (state_ == BULLET || state_ == GROUP ||
					 state_ == BULLET_GROUP)
			{
				Game::instance()->switchScreenMode(true);
			}
		}
	}

	if (state_ == END && mode == 0) {
		conf->normal_ = true;

		if (!Game::instance()->screenIsLarge()) {
			Game::instance()->switchScreenMode(true);
		}

		putInfoFrames();

		const Rect& r = Screen::MAIN_FRAME;
		putDimmedRect(
			r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);

		conf->title_ = "m[}()";
	}
	else if (mode == 1) {
		conf->title_ = "Vv";
	}

	std::string cpuInfluence = getStringFromMap(conf_, "cpu_influence");
	if (cpuInfluence == "") conf->humanConfidence_ = 10;
	else if (cpuInfluence == "") conf->humanConfidence_ = 1000;
	else conf->humanConfidence_ = 100;

	if ((mode == 2 || mode == 3) && state_ == END &&
		std::string("model") == getStringFromMap(conf_, "player_input"))
	{
		int bullet = getSizeFromMap(conf_, "bullet");
		std::string pre =
			"model/" +
			Game::instance()->getBulletInfo()->descriptions()[bullet]->file();
		startReplay(pre);
	}
}

void Select::loadConf() {
	ConfMapGenerater cmg;
	cmg.setReportDevice(std::cerr);
	cmg.generate("save/conf", conf_);

}

void Select::fastRun() {
	loadConf();

	Conf* conf = Conf::instance();
	conf->mode_ = 2;
}

int Select::run() {
	Game::instance()->mainFrame()->fill(Color::BLACK);

	while (state_ != END) {
		Game::instance()->waitInputRelease();

		loadConf();

		setConf();

		while (getStringFromMap(conf_, "name").empty()) {
			inputName();
			if (state_ == QUIT) break;
			Game::instance()->mainFrame()->fill(Color::BLACK);
		}

		Game::instance()->mainFrame()->fill(Color::BLACK);

		State nowState = state_;

		if (state_ == TITLE) selectTitle();
		else if (state_ == MODE) selectMode();
		else if (state_ == BULLET) selectBullet();
		else if (state_ == GROUP) selectGroup();
		else if (state_ == BULLET_GROUP) selectBulletGroup();
		else if (state_ == BULLET_DETAIL) selectBulletDetail();
		else if (state_ == CONFIG) selectConfig();
		else if (state_ == ESCAPE) return 1;
		else if (state_ == QUIT) return -1;
		else if (state_ == REPLAY) selectReplay();
		else if (state_ == START_REPLAY) break;

		if (nowState != state_) prevState_ = nowState;

		if (state_ == BULLET || state_ == END) {
			Game::instance()->getBulletInfo()->loadUserInfo(
				getStringFromMap(conf_, "name"));
		}

		ConfMapGenerater cmg;
		cmg.save("save/conf", conf_);

		if (state_ == END) setConf();
	}

	if (state_ == START_REPLAY) {
		std::string prefix = "replay/" + getStringFromMap(conf_, "replay_num");
		startReplay(prefix);
		Game::instance()->getBulletInfo()->loadUserInfo(
			getStringFromMap(conf_, "name"));
	}

	return 0;
}

void Select::startReplay(const std::string& prefix) {
	ConfMapGenerater cmg;
	cmg.setReportDevice(std::cerr);
	std::string confFile(prefix + "-conf.dat");
	if (!std::ifstream(confFile.c_str()).is_open()) {
		state_ = BULLET_DETAIL;
		return;
	}
	cmg.generate(confFile, conf_);

	if (getSizeFromMap(conf_, "mode") == 2 ||
		getSizeFromMap(conf_, "mode") == 3)
	{
		Game::instance()->switchScreenMode(true);

		putInfoFrames();

		const Rect& r = Screen::MAIN_FRAME;
		putDimmedRect(
			r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);

		putBulletInfo(getSizeFromMap(conf_, "bullet"));
	}

	state_ = END;

	setConf();

	Game::instance()->loadReplay(prefix);

	Conf::instance()->replay_ = true;
}

Select::Action Select::selectAny(const std::vector<std::string>& strs,
								 const Point& pnt, int yspace,
								 size_t& index, size_t& scroll, size_t cols)
{
	static int prev = 2;
	while (1) {
		putDimmedString(strs[index],
								   Point(pnt.xi(),
										 pnt.yi()+yspace*(index-scroll)),
								   Color::RED);
		screen_->flip();

		std::auto_ptr<MSDL::InputState> state;

		if (prev != 1) {
			SDL_Delay(100);
		}
		prev = 0;

		do {
			SDL_PumpEvents();
			state.reset(new MSDL::InputState(*input_));
			Game::instance()->endEv();
			if (Game::instance()->isQuit()) {
				state_ = QUIT;
				return ACT_QUIT;
			}
			SDL_Delay(50);
			prev++;
		} while (!state->getAny());

		putDimmedString(strs[index],
								   Point(pnt.xi(),
										 pnt.yi()+yspace*(index-scroll)),
								   Color::WHITE);

		if (state->getAxis().isDown() && index != strs.size()-1) {
			index++;

			if (index >= cols+scroll) {
				scroll++;

				Point sp(pnt.xi()-DIM, pnt.yi()-DIM+yspace);
				Point ep(pnt.xi()+getStringMaxWidth(strs)+DIM,
						 pnt.yi()+getStringHeight(yspace, cols)+DIM);
				Rect rec(sp, ep);

				Surface tmp(rec.size(), 16, SDL_SWSURFACE);
				tmp.blit(screen_, rec, Rect(Point(0, 0), rec.size()));
				Point p(sp-Point(0, yspace));
				screen_->blit(&tmp, p);

				Point sp2(pnt.xi()-DIM,
						  pnt.yi()+getStringHeight(yspace, cols-1)+DIM);
				screen_->fillRect(Rect(sp2, ep), Color::BLACK);
			}

			return ACT_DOWN;
		}
		else if (state->getAxis().isUp() && index != 0) {
			index--;

			if (index < scroll) {
				scroll--;

				Point sp(pnt.xi()-DIM, pnt.yi()-DIM);
				Point ep(pnt.xi()+getStringMaxWidth(strs)+DIM,
						 pnt.yi()+getStringHeight(yspace, cols-1)+DIM);
				Rect rec(sp, ep);

				Surface tmp(rec.size(), 16, SDL_SWSURFACE);
				tmp.blit(screen_, rec, Rect(Point(0, 0), rec.size()));
				Point p(sp+Point(0, yspace));
				screen_->blit(&tmp, p);

				Point ep2(pnt.xi()+getStringMaxWidth(strs)+DIM,
						  pnt.yi()+getStringHeight(yspace, 1)+DIM);
				screen_->fillRect(Rect(sp, ep2), Color::BLACK);
			}

			return ACT_UP;
		}
		else if (state->getAxis().isRight()) return ACT_RIGHT;
		else if (state->getAxis().isLeft()) return ACT_LEFT;
		else if (state->getButton(3)) {
			if (index > 15) index -= 15;
			else index = 0;
			if (index < scroll) {
				scroll = index;
				Point sp(pnt.xi()-DIM, pnt.yi()-DIM);
				Point ep(pnt.xi()+getStringMaxWidth(strs)+DIM,
						 pnt.yi()+getStringHeight(yspace, cols)+DIM);
				Rect rec(sp, ep);
				screen_->fillRect(rec, Color::BLACK);
				putStringList(strs, pnt, yspace, cols, scroll);
			}
			return ACT_UP;
		}
		else if (state->getButton(4)) {
			if (index+15 < strs.size()) index += 15;
			else index = strs.size()-1;
			if (index >= cols+scroll) {
				scroll = index-cols+1;
				Point sp(pnt.xi()-DIM, pnt.yi()-DIM);
				Point ep(pnt.xi()+getStringMaxWidth(strs)+DIM,
						 pnt.yi()+getStringHeight(yspace, cols)+DIM);
				Rect rec(sp, ep);
				screen_->fillRect(rec, Color::BLACK);
				putStringList(strs, pnt, yspace, cols, scroll);
			}
			return ACT_DOWN;
		}

		if (state->getButton(0)) return ACT_DECISION;
		else if (state->getButton(1)) return ACT_CANCEL;
		else if (state->getButton(2)) {
			state_ = ESCAPE;
			return ACT_QUIT;
		}
	}
}

void Select::inputName() {
	static const std::string chars(" ABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890.");

	putDimmedString("O͂Ă enter your name",
					Point(10, 250), Color::WHITE);
	putDimmedString("㉺Eœ͂āAA{^Ōł",
					Point(30, 350), Color::WHITE);
	putDimmedString("you can use arrow key and z key or joystick",
					Point(30, 370), Color::WHITE);


	size_t x = 0, y = 0, prev = 2;
	std::string name("   ");


	screen_->putString("_", Point(200+x*8, 304), Color::RED);

	while (1) {
		screen_->flip();

		std::auto_ptr<MSDL::InputState> state;

		if (prev != 1) {
			SDL_Delay(100);
		}
		prev = 0;

		do {
			SDL_PumpEvents();
			state.reset(new MSDL::InputState(*input_));
			Game::instance()->endEv();
			if (Game::instance()->isQuit()) {
				state_ = QUIT;
				return;
			}
			SDL_Delay(50);
			prev++;
		} while (!state->getAny());

		if (state->getAxis().isDown() || state->getAxis().isUp()) {
			if (state->getAxis().isDown()) {
				y++;
				if (chars.size() == y) y = 0;
			}
			else {
				if (0 == y) y = chars.size();
				y--;
			}

			screen_->fillRect(Rect(200+x*8, 300, 8, 12, true), Color::BLACK);
			screen_->putString(chars.substr(y, 1),
							   Point(200+x*8, 300), Color::RED);
			name[x] = chars[y];
		}

		else if (state->getAxis().isRight() || state->getAxis().isLeft()) {
			screen_->fillRect(Rect(200+x*8, 300, 8, 20, true), Color::BLACK);
			screen_->putString(chars.substr(y, 1),
							   Point(200+x*8, 300), Color::WHITE);

			if (state->getAxis().isRight()) {
				if (x != 2) x++;
			}
			else {
				if (x != 0) x--;
			}
			y = chars.find(name[x]);

			screen_->putString(chars.substr(y, 1),
							   Point(200+x*8, 300), Color::RED);
			screen_->putString("_", Point(200+x*8, 304), Color::RED);
		}

		if (state->getButton(0) && name != "   ") break;
		else if (state->getButton(1) || state->getButton(2)) {
			return;
		}
	}

	while (name[name.size()-1] == ' ') name.erase(name.size()-1);
	conf_["name"] = name;

	std::ifstream is("save/names");
	while (!is.eof()) {
		std::string n;
		is >> n;
		if (n == name) return;
	}
	is.close();

	std::ofstream os("save/names", std::ios::app);
	os << name << std::endl;
}

void Select::selectReplay() {
	std::vector<std::string> strs, nums;
	for (int i = 0; i < 10; i++) {
		std::string numStr = boost::lexical_cast<std::string>(i);
		std::ifstream is(("replay/"+numStr+"-name.dat").c_str());
		if (is.is_open()) {
			std::string title, score;
			is >> title >> score;
			nums.push_back(numStr);
			strs.push_back(numStr+" "+title+" "+score);
		}
	}

	if (strs.empty()) {
		state_ = MODE;
		return;
	}

	size_t index = 0;

	putStringList(strs, Point(10, 100), 25);
	while (1) {
		Action act = selectAny(strs, Point(10, 100), 25, index);

		if (act == ACT_CANCEL) {
			state_ = MODE;
			return;
		}
		if (act == ACT_QUIT) {
			return;
		}

		if (act == ACT_DECISION) {
			break;
		}
	}

	conf_["replay_num"] = boost::lexical_cast<std::string>(nums[index]);

	state_ = START_REPLAY;
}

void Select::selectTitle() {
	//Conf::instance()->reset();

	if (getBoolFromMap(conf_, "fix_large")) {
		if (!Game::instance()->screenIsLarge()) {
			Game::instance()->switchScreenMode(true);

			putInfoFrames();
			const Rect& r = Screen::MAIN_FRAME;
			putDimmedRect(
				r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);
		}
	}
	else {
		Game::instance()->switchScreenMode(false);
	}

	std::string bmp = Conf::instance()->bmpdir();
	screen_->loadBMP(bmp+"/logo.bmp", Point(75, 100));
	screen_->flip();

	Game::instance()->waitInputRelease();
	if (0 != Game::instance()->waitAnyInput()) {
		state_ = QUIT;
		return;
	}

	Game::instance()->mainFrame()->fill(Color::BLACK);
	screen_->flip();

	state_ = MODE;
}

void Select::selectMode() {
	std::vector<std::string> strs;
	strs.push_back("m[} (NORMAL)");
	strs.push_back("Vv (SIMPLE)");
	strs.push_back("ZNg (SELECT)");
	strs.push_back("O[v (GROUP)");
	strs.push_back("RtBO (CONFIG)");
	strs.push_back("LO (RANKING)");
	strs.push_back("vC (REPLAY)");

	size_t mode = getSizeFromMap(conf_, "mode");

	putStringList(strs, Point(150, 180), 30);
	while (1) {
		Action act = selectAny(strs, Point(150, 180), 30, mode);

		if (act == ACT_CANCEL) {
			state_ = ESCAPE;
			return;
		}
		if (act == ACT_QUIT) {
			return;
		}

		if (act == ACT_DECISION) {
			if (mode != 5) break;

			Game::instance()->mainFrame()->fill(Color::BLACK);
			nowRank_ = -1;
			putRanking();
			Game::instance()->waitInputRelease();
			Game::instance()->waitAnyInput();
			Game::instance()->waitInputRelease();
			Game::instance()->mainFrame()->fill(Color::BLACK);
			putStringList(strs, Point(150, 180), 30);
		}
	}

	conf_["mode"] = boost::lexical_cast<std::string>(mode);

	if (mode == 2) state_ = BULLET;
	else if (mode == 3) state_ = GROUP;
	else if (mode == 4) state_ = CONFIG;
	else if (mode == 6) state_ = REPLAY;
	else state_ = END;
}

void Select::putBulletInfo(size_t s) {
	putBulletInfo(Game::instance()->getBulletInfo()->descriptions()[s]);
}

void Select::putBulletInfo(BulletDescription* info) {
	const Rect& r1 = Screen::DESCRIPTION_FRAME;
	putParagraph(r1, info->description(), 40);

	const Rect& r2 = Screen::CAPTURE_FRAME;
	putParagraph(r2, info->capture(), 40);

	if (Conf::instance()->english()) {
		putStatusLine(info->file());
	}
	else {
		putStatusLine(info->title());
	}

	const Rect& r4 = Screen::PLAYERINFO_FRAME;
	screen_->fillRect(Rect(r4.x()+RECMARGIN,r4.y()+RECMARGIN,
						   r4.x2()-RECMARGIN,r4.y2()-RECMARGIN), Color::BLACK);
	int come = info->getCome();
	int damage = info->getDamage();
	int success = info->getSuccessPer();
	int rank = info->getLimit();
	std::vector<std::string> strs;
	//strs.push_back("o: " + boost::lexical_cast<std::string>(come));
	//strs.push_back("e: " + boost::lexical_cast<std::string>(damage));
	strs.push_back("  : " + boost::lexical_cast<std::string>(success));
	strs.push_back("ōRank: " + boost::lexical_cast<std::string>(rank));
	if (info->eval()) {
		strs.push_back("");
		strs.push_back("Փx: " + boost::lexical_cast<std::string>(info->difficulty()));
		strs.push_back("ex: " + boost::lexical_cast<std::string>(info->speed()));
		strs.push_back("e: " + boost::lexical_cast<std::string>(info->density()));
		strs.push_back("@_: " + boost::lexical_cast<std::string>(info->aim()));
		strs.push_back("x: " + boost::lexical_cast<std::string>(info->tricky()));
	}
	putStringList(strs, r4.start()+Point(MARGIN, MARGIN), 20);
}

void Select::selectBulletGroup() {
	std::string groupSysname = getStringFromMap(conf_, "group");

	BulletInfo* info = Game::instance()->getBulletInfo();
	std::vector<BulletDescription*> descDisplay
		= info->getGroupBullets(groupSysname);

	if (descDisplay.size() == 0) {
		state_ = GROUP;
		return;
	}

	const std::vector<BulletDescription*>& desc = info->descriptions();
	std::vector<std::string> names;
	std::transform(descDisplay.begin(), descDisplay.end(),
				   std::back_inserter(names),
				   std::mem_fun(&BulletDescription::title));

	putInfoFrames();

	const Rect& r = Screen::MAIN_FRAME;
	putDimmedRect(r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);

	static const Point p(r.start()+Point(MARGIN, MARGIN));
	static const int yspace = 16;
	static const size_t cols = 24;

	size_t bulletId = getSizeFromMap(conf_, "bullet");

	std::vector<std::string>::iterator ite =
		std::find(names.begin(), names.end(), desc[bulletId]->title());
	size_t bullet = 0;
	if (ite != names.end()) bullet = std::distance(names.begin(), ite);

	bulletId = descDisplay[bullet]->id();

	putBulletInfo(desc[bulletId]);

	const Rect& r3 = Screen::PREVIEW_FRAME;

	if (bulletId != 0 && desc[bulletId]->hasShot()) {
		if (desc[bulletId]->shot()) {
			screen_->blit(desc[bulletId]->shot(),
						  r3.start()+Point(DIM-1, DIM+1));
		}
		else {
			screen_->loadBMP(
				std::string("shots/")+desc[bulletId]->file()+".bmp",
				r3.start()+Point(DIM-1, DIM+1));
		}
	}
	else {
		screen_->blit(logo_.get(), r3.start()+Point(DIM-1, DIM+1));
	}

	size_t scroll = std::max(bullet+1, cols) - cols;

	putStringList(names, p, yspace, cols, scroll);
	while (1) {
		Action act = selectAny(names, p, yspace, bullet, scroll, cols);

		if (act == ACT_CANCEL) {
			state_ = GROUP;
			return;
		}
		if (act == ACT_QUIT) {
			return;
		}

		if (act == ACT_UP || act == ACT_DOWN) {
			bulletId = descDisplay[bullet]->id();
			putBulletInfo(desc[bulletId]);

			if (bulletId != 0 && desc[bulletId]->hasShot()) {
				if (desc[bulletId]->shot()) {
					screen_->blit(desc[bulletId]->shot(),
								  r3.start()+Point(DIM-1, DIM+1));
				}
				else {
					screen_->loadBMP(
						std::string("shots/")+desc[bulletId]->file()+".bmp",
						r3.start()+Point(DIM-1, DIM+1));
				}
			}
			else {
				screen_->blit(logo_.get(), r3.start()+Point(DIM-1, DIM+1));
			}
		}

		if (act == ACT_DECISION) break;
	}

	conf_["bullet"] = boost::lexical_cast<std::string>(bulletId);

	state_ = BULLET_DETAIL;
}

void Select::selectGroup() {
	BulletInfo* info = Game::instance()->getBulletInfo();

	const std::vector<std::string>& sysGroups = info->groups();
	std::vector<std::string> groups;
	std::transform(sysGroups.begin(), sysGroups.end(),
				   std::back_inserter(groups),
				   boost::bind1st(boost::mem_fun(&BulletInfo::getGroupName),
								  info));

	putInfoFrames();

	const Rect& r = Screen::MAIN_FRAME;
	putDimmedRect(r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);

	static const Point p(r.start()+Point(MARGIN, MARGIN));
	static const int yspace = 16;

	std::string groupName = getStringFromMap(conf_, "group");
	std::vector<std::string>::const_iterator ite =
		std::find(sysGroups.begin(), sysGroups.end(), groupName);
	size_t group;
	if (ite == sysGroups.end()) group = 0;
	else group = std::distance(sysGroups.begin(), ite);

	static const size_t cols = 24;
	size_t scroll = std::max(group+1, cols) - cols;

	putStringList(groups, p, yspace, cols, scroll);
	while (1) {
		Action act = selectAny(groups, p, yspace, group, scroll, cols);

		if (act == ACT_CANCEL) {
			state_ = MODE;
			return;
		}
		if (act == ACT_QUIT) {
			return;
		}

		if (act == ACT_UP || act == ACT_DOWN) {
		}

		if (act == ACT_DECISION) break;
	}

	conf_["group"] = boost::lexical_cast<std::string>(sysGroups[group]);
	state_ = BULLET_GROUP;
}

void Select::selectBullet() {
	BulletInfo* info = Game::instance()->getBulletInfo();
	const std::vector<BulletDescription*>& descDisplay =
		info->descriptionsDisplayOrder();

	const std::vector<BulletDescription*>& desc = info->descriptions();
	std::vector<std::string> names;
	std::transform(descDisplay.begin(), descDisplay.end(),
				   std::back_inserter(names),
				   std::mem_fun(&BulletDescription::title));

	putInfoFrames();

	const Rect& r = Screen::MAIN_FRAME;
	putDimmedRect(r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);

	static const Point p(r.start()+Point(MARGIN, MARGIN));
	static const int yspace = 16;
	static const size_t cols = 24;

	size_t bulletId = getSizeFromMap(conf_, "bullet");

	putBulletInfo(desc[bulletId]);

	size_t bullet = std::distance(names.begin(),
								  std::find(names.begin(), names.end(),
											desc[bulletId]->title()));

	size_t scroll = std::max(bullet+1, cols) - cols;

	const Rect& r3 = Screen::PREVIEW_FRAME;

	if (bulletId != 0 && desc[bulletId]->hasShot()) {
		if (desc[bulletId]->shot()) {
			screen_->blit(desc[bulletId]->shot(),
						  r3.start()+Point(DIM-1, DIM+1));
		}
		else {
			screen_->loadBMP(
				std::string("shots/")+desc[bulletId]->file()+".bmp",
				r3.start()+Point(DIM-1, DIM+1));
		}
	}
	else {
		screen_->blit(logo_.get(), r3.start()+Point(DIM-1, DIM+1));
	}

	putStringList(names, p, yspace, cols, scroll);
	while (1) {
		Action act = selectAny(names, p, yspace, bullet, scroll, cols);

		if (act == ACT_CANCEL) {
			state_ = MODE;
			return;
		}
		if (act == ACT_QUIT) {
			return;
		}

		if (act == ACT_UP || act == ACT_DOWN) {
			bulletId = descDisplay[bullet]->id();
			putBulletInfo(desc[bulletId]);

			if (bulletId != 0 && desc[bulletId]->hasShot()) {
				if (desc[bulletId]->shot()) {
					screen_->blit(desc[bulletId]->shot(),
								  r3.start()+Point(DIM-1, DIM+1));
				}
				else {
					screen_->loadBMP(
						std::string("shots/")+desc[bulletId]->file()+".bmp",
						r3.start()+Point(DIM-1, DIM+1));
				}
			}
			else {
				screen_->blit(logo_.get(), r3.start()+Point(DIM-1, DIM+1));
			}
		}

		if (act == ACT_DECISION) break;
	}

	conf_["bullet"] = boost::lexical_cast<std::string>(bulletId);

	state_ = BULLET_DETAIL;
}

Select::Action
Select::selectConfigMenu(const std::string& str, Point pk,
						 Point pv, Point pd, int yspace,
						 const std::vector<std::string>& addstrs)
{
	ConfigMenu cm(str);

	std::vector<std::string> vals;
	for (size_t i = 0; i < cm.key.size(); i++) {
		std::string key = cm.key[i];
		ConfMap::iterator item = conf_.find(key);
		std::string now;
		if (item == conf_.end()) {
			now = cm.value[i];
			conf_[key] = now;
		}
		else {
			now = item->second;
		}
		vals.push_back(now);
	}

	std::vector<std::string> titles(cm.title.begin(), cm.title.end());
	std::copy(addstrs.begin(), addstrs.end(), std::back_inserter(titles));
	titles.push_back("ftHgɖ߂ (to default)");

	putStringList(titles, pk, yspace);
	putStringList(vals, pv, yspace);

	size_t height = 0;
	putDimmedString(cm.desc[height], pd, Color::WHITE);
	while (1) {
		Action act = selectAny(titles, pk, yspace, height);

		if (act == ACT_CANCEL) {
			return ACT_CANCEL;
		}
		if (act == ACT_QUIT) {
			return ACT_QUIT;
		}

		if (act == ACT_RIGHT || act == ACT_LEFT) {
			if (height >= vals.size()) continue;

			std::string key = cm.key[height];
			ConfMap::iterator item = conf_.find(key);
			assert(item != conf_.end());

			std::string now = item->second;

			std::vector<std::string>::const_iterator ites =
				std::find(cm.selects[height].begin(),
						  cm.selects[height].end(), now);
			check(ites != cm.selects[height].end(), "data error");

			if (act == ACT_RIGHT) {
				ites++;
				if (ites == cm.selects[height].end()) ites--;
			}
			else if (act == ACT_LEFT) {
				if (ites != cm.selects[height].begin()) ites--;
			}

			conf_[key] = *ites;
			vals[height] = *ites;

			Rect r(pv + Point(0, height*yspace),
				   Point(now.length()*screen_->fontWidth(),
						 screen_->fontHeight()), true);
			screen_->fillRect(getDimmedRect(r), Color::BLACK);
			putDimmedString(*ites, r.start(), Color::WHITE);
		}

		if (act == ACT_UP || act == ACT_DOWN) {
			Rect r(pd, Point(getStringMaxWidth(cm.desc),
							 screen_->fontHeight()), true);
			screen_->fillRect(getDimmedRect(r), Color::BLACK);
			if (height < vals.size()) {
				putDimmedString(cm.desc[height], pd, Color::WHITE);
			}
		}

		if (act == ACT_DECISION) {
			if (height+1 == titles.size()) {
				Rect r(pv, Point(getStringMaxWidth(vals),
								 getStringHeight(yspace, vals.size())), true);
				screen_->fillRect(getDimmedRect(r), Color::BLACK);

				vals.clear();
				for (size_t i = 0; i < cm.key.size(); i++) {
					std::string key = cm.key[i];
					std::string now = cm.value[i];
					conf_[key] = now;
					vals.push_back(now);
				}
				putStringList(vals, pv, yspace);
			}
			else if (height >= vals.size()) {
				int i = height - vals.size();
				if (i == 0) return ACT_USR1;
				else if (i == 1) return ACT_USR2;
				else if (i == 2) return ACT_USR3;
				assert(0);
			}
			else {
				break;
			}
		}
	}

	return ACT_DECISION;
}

void Select::selectBulletDetail() {
	const Rect& r = Screen::MAIN_FRAME;
	screen_->fillRect(r, Color::BLACK);
	putDimmedRect(r.x()-2, r.y()-2, r.w()+4, r.h()+4, Color::WHITE);

	static const Point p(r.start()+Point(MARGIN, MARGIN));
	static const int yspace = 20;

	while (1) {
		Action act = selectConfigMenu("data/BulletDetail.dat", p,
									  p+Point(200,0), p+Point(0,300), yspace);

		if (act == ACT_CANCEL) {
			state_ = prevState_;
			return;
		}
		if (act == ACT_QUIT) {
			return;
		}

		if (act == ACT_DECISION) break;
	}

	state_ = END;

}

void Select::selectConfig() {
	static const Point p(20, 30);
	static const int yspace = 20;

	std::vector<std::string> addstrs;
	addstrs.push_back("VKvC[ (new player)");

	while (1) {
		Action act = selectConfigMenu("data/Config.dat", p, p+Point(200,0),
									  p+Point(0, 320), yspace, addstrs);

		if (act == ACT_CANCEL) {
			state_ = MODE;
			return;
		}
		if (act == ACT_QUIT) {
			return;
		}

		if (act == ACT_DECISION) {
			break;
		}

		if (act == ACT_USR1) {
			Game::instance()->mainFrame()->fill(Color::BLACK);
			inputName();
			Game::instance()->mainFrame()->fill(Color::BLACK);
		}
	}

	state_ = MODE;

}

Select::ConfigMenu::ConfigMenu(const std::string& filename) {
	std::ifstream is(filename.c_str());
	check(is.is_open(), filename + ": not found.");

	while (!is.eof()) {
		static const int MAXBUF = 1000;
		char ln[MAXBUF];
		if (is.getline(ln, MAXBUF) == 0) break;

		std::istringstream iss(ln);
		char tic[MAXBUF], dec[MAXBUF], kec[MAXBUF], vac[MAXBUF], typec[MAXBUF];
		iss >> tic >> dec >> kec >> vac >> typec;
		std::string ti(tic);
		std::string de(dec);
		std::string ke(kec);
		std::string va(vac);
		std::string type(typec);
		title.push_back(ti);
		desc.push_back(de);
		key.push_back(ke);
		value.push_back(va);

		selects.push_back(std::vector<std::string>());
		std::vector<std::string>& se = selects.back();

		if (type == "RANGE") {
			float start, end, step;
			iss >> start >> end >> step;

			for (float i = start; i <= end; i += step) {
				se.push_back(boost::lexical_cast<std::string>(i));
			}
		}
		else if (type == "ENUM") {
			std::copy(std::istream_iterator<std::string>(iss),
					  std::istream_iterator<std::string>(),
					  std::back_inserter(se));
		}
		else if (type == "FILE") {
			std::string filename;
			iss >> filename;
			std::ifstream is(filename.c_str());
			std::copy(std::istream_iterator<std::string>(is),
					  std::istream_iterator<std::string>(),
					  std::back_inserter(se));
		}
		else if (type == "DIR") {
			std::string dirname;
			iss >> dirname;
			Dir dir(dirname);
			for (Dir::iterator ite = dir.begin(); ite != dir.end(); ite++) {
				std::ifstream checkis((dir.full(*ite)+"/ball_w.bmp").c_str());
				if (!checkis.is_open()) continue;
				se.push_back(*ite);
			}
		}
	}
}

void Select::insertRanking(int point, bool sp) {
	nowPoint_ = point;

	std::vector<RankElem>& rank = (sp) ? spRanking_ : normalRanking_;
	std::string name = getStringFromMap(conf_, "name");

	rank.push_back(std::make_pair(name, point));
	nowRank_ = (sp) ? -3 : -2;

	std::vector<RankElem>::iterator ite = rank.begin();
	int i;
	for (i = 0; i < 10; i++) {
		if (point >= ite->second) {
			rank.insert(ite, std::make_pair(name, point));
			nowRank_ = i + ((sp) ? 10 : 0);
			rank.pop_back();
			break;
		}
		ite++;
	}

	std::ofstream os("save/score.dat");
	for (i = 0; i < 10; i++) {
		os << normalRanking_[i].first << '\t'
		   << normalRanking_[i].second << std::endl;
	}
	for (i = 0; i < 10; i++) {
		os << spRanking_[i].first << '\t'
		   << spRanking_[i].second << std::endl;
	}

}

int Select::saveReplay() {
	Surface* s = Game::instance()->mainFrame();
	putDimmedString("{^ĉ (push any key)",
					Point(30, 330), Color::WHITE, s);
	putDimmedString("L[{[h 0-9 ΃vCc܂",
					Point(10, 350), Color::WHITE, s);
	putDimmedString("(push 0-9 key to save replay)",
					Point(10, 370), Color::WHITE, s);

	screen_->flip();

	int ret = 0;
	while (ret == 0) {
		SDL_Delay(50);
		SDL_Event ev;
		while (SDL_PollEvent(&ev)) {
			if (ev.type == SDL_QUIT) {
				Game::instance()->end();
				Game::instance()->quit();
				return -1;
			}
			else if (ev.type == SDL_KEYDOWN) {
				char key = static_cast<char>(ev.key.keysym.sym);
				if (key != ' ') {
					std::string name(boost::lexical_cast<std::string>(key));
					if (key == 'x') {
						const std::vector<BulletDescription*>& desc =
							Game::instance()->getBulletInfo()->descriptions();
						name = desc[getSizeFromMap(conf_, "bullet")]->file();
					}
					else if (!isdigit((unsigned char)key)) continue;
					Game::instance()->saveReplay(name);
					ConfMapGenerater cmg;
					cmg.save(std::string("replay/")+name+"-conf.dat", conf_);
					s->fillRect(Rect(5, 365, 295, 390), Color::BLACK);
					putDimmedString(std::string("")+name+"ɕۑ܂",
									Point(10, 370), Color::WHITE, s);
					screen_->flip();
				}
			}
		}

		ret = Game::instance()->getAnyInput();
	}
	if (ret == -1) return -1;
	return 0;
}

int Select::putRanking() {
	Surface* s = Game::instance()->mainFrame();
	std::string name = getStringFromMap(conf_, "name");

	putDimmedString("m[}/Vv[h", Point(10, 50), Color::WHITE);
	putDimmedString("XyV[h", Point(160, 50), Color::WHITE);

	std::string rankStr[] = {
		" 1ST  ", " 2ND  ", " 3RD  ", " 4TH  ", " 5TH  ",
		" 6TH  ", " 7TH  ", " 8TH  ", " 9TH  ", "10TH  "
	};

	for (int i = 0; i < 10; i++) {
		const Color* c = &Color::WHITE;

		if (i != nowRank_) c = &Color::WHITE;
		else c = &Color::RED;
		putDimmedString(rankStr[i] + normalRanking_[i].first,
						Point(10, 100+i*20), *c, s);
		putDimmedString(
			boost::lexical_cast<std::string>(normalRanking_[i].second),
			Point(80, 100+i*20), *c, s);

		if (i != nowRank_ - 10) c = &Color::WHITE;
		else c = &Color::RED;
		putDimmedString(rankStr[i] + spRanking_[i].first,
						Point(160, 100+i*20), *c, s);
		putDimmedString(
			boost::lexical_cast<std::string>(spRanking_[i].second),
			Point(230, 100+i*20), *c, s);
	}

	if (nowRank_ == -2) {
		putDimmedString(" OUT  " + name,
						Point(10, 300), Color::RED, s);
		putDimmedString(
			boost::lexical_cast<std::string>(nowPoint_),
			Point(80, 300), Color::RED, s);
	}
	else if (nowRank_ == -3) {
		putDimmedString(" OUT  " + name,
						Point(160, 300), Color::RED, s);
		putDimmedString(
			boost::lexical_cast<std::string>(nowPoint_),
			Point(230, 300), Color::RED, s);
	}

	putDimmedString("{^ĉ",
					Point(30, 330), Color::WHITE, s);

	screen_->flip();

	return 0;
}

void Select::putStatusLine(const std::string& str) {
	const Rect& r3 = Screen::STATUS_FRAME;
	screen_->fillRect(Rect(r3.start() + Point(DIM, DIM),
						   r3.end() - Point(DIM, DIM)), Color::BLACK);
	putDimmedString(str, r3.start()+Point(DIM+5, DIM+3), Color::WHITE);

}
