#ifndef BOHA_SCREEN
#define BOHA_SCREEN

#include "surface.h"

// CEBhE
class Screen : public Surface, public Singleton<Screen> {
public:
    Screen();
//    Screen(int x = DEFAULT_MINI_X, int y = DEFAULT_MINI_Y, Uint32 addFlag =0);

private:
	void init(int x, int y, Uint32 addFlag);

public:
	virtual ~Screen();

    void loadBMP(const std::string& str);
    void loadBMP(const std::string& str, const Point& pnt);

    int flip();

	void resize(int x, int y, Uint32 addFlag);
	void resize(const Point& p, Uint32 addFlag) {
		resize(p.xi(), p.yi(), addFlag);
	}

protected:
	/// ۂɌĂ surface
	SDL_Surface* display_;

public:
	static const int WIDTH;
	static const int HEIGHT;
	static const int DEFAULT_MINI_X;
	static const int DEFAULT_MINI_Y;
	static const int DEFAULT_NORMAL_X;
	static const int DEFAULT_NORMAL_Y;
    static const Uint32 FLAG;
	static const Rect MAIN_FRAME;
	static const Rect DESCRIPTION_FRAME;
	static const Rect CAPTURE_FRAME;
	static const Rect PLAYERINFO_FRAME;
	static const Rect PREVIEW_FRAME;
	static const Rect STATUS_FRAME;

};

#endif // ! BOHA_SCREEN
