#include "screen.h"

#include <SDL_kanji_f1b/SDL_kanji.h>

const int Screen::DEFAULT_MINI_X = 300;
const int Screen::DEFAULT_MINI_Y = 400;
const int Screen::DEFAULT_NORMAL_X = 600;
const int Screen::DEFAULT_NORMAL_Y = 450;
const Uint32 Screen::FLAG = SDL_SWSURFACE;

const int Screen::WIDTH = DEFAULT_MINI_X;
const int Screen::HEIGHT = DEFAULT_MINI_Y;

const Rect Screen::MAIN_FRAME(10, 10, DEFAULT_MINI_X, DEFAULT_MINI_Y, true);
const Rect Screen::DESCRIPTION_FRAME(321, 8, 272, 107, true);
const Rect Screen::CAPTURE_FRAME(321, 121, 272, 107, true);
const Rect Screen::PLAYERINFO_FRAME(484, 234, 108, 208, true);
const Rect Screen::PREVIEW_FRAME(321, 234, 156, 208, true);
const Rect Screen::STATUS_FRAME(8, 417, DEFAULT_MINI_X+4, 25, true);

void Screen::loadBMP(const std::string& str) {
    Surface bw(str);
    blit(&bw);
}
void Screen::loadBMP(const std::string& str, const Point& pnt) {
    Surface bw(str);

    Rect src(Point(0, 0), bw.size());
    Rect dst(pnt, Point(0, 0));
    blit(&bw, src, dst);
}

void Screen::init(int x, int y, Uint32 addFlag) {
	display_ = SDL_SetVideoMode(x, y, 16, FLAG|addFlag);
	assert(display_ != 0);

	if ((x == DEFAULT_MINI_X && y == DEFAULT_MINI_Y) ||
		x == DEFAULT_NORMAL_X && y == DEFAULT_NORMAL_Y)
	{
		surf_ = display_;
		size_ = Point(x, y);
	}
	else {
		if (x > y) {
			surf_ = SDL_CreateRGBSurface(SDL_SWSURFACE,
										 DEFAULT_NORMAL_X, DEFAULT_NORMAL_Y,
										 16, 0, 0, 0, 0);
			assert(surf_ != 0);

			size_ = Point(DEFAULT_NORMAL_X, DEFAULT_NORMAL_Y);
		}
		else {
			surf_ = SDL_CreateRGBSurface(SDL_SWSURFACE,
										 DEFAULT_MINI_X, DEFAULT_MINI_Y,
										 16, 0, 0, 0, 0);
			assert(surf_ != 0);

			size_ = Point(DEFAULT_MINI_X, DEFAULT_MINI_Y);
		}
	}

	calcCache();
}

Screen::Screen() {}
/*
Screen::Screen(int x, int y, Uint32 addFlag) {
	init(x, y, addFlag);
}
*/

void Screen::resize(int x, int y, Uint32 addFlag) {
	std::cout << "screen resized (" << x << ", " << y << ")" << std::endl;

	//if (display_ != surf_) SDL_FreeSurface(surf_);
	init(x, y, addFlag);
}

Screen::~Screen() {
	if (display_ != surf_) SDL_FreeSurface(display_);

}

int Screen::flip() {
	if (surf_ != display_) {
		// ǂĝc
		SDL_SoftStretch(surf_, 0, display_, 0);
	}

	return SDL_Flip(display_);
}
