#ifndef REPLAYER_H_
#define REPLAYER_H_

#include <string>
#include <vector>
#include <fstream>

#include <SDL.h>

template <typename T_>
class Recorder {
public:
	Recorder() {}
	Recorder(size_t s) : vals_(s) {}

	void push(T_ val) {
		vals_.push_back(val);
	}

	void save(const std::string& file) const {
		std::ofstream os(file.c_str(), std::ios::binary);
		for (typename std::vector<T_>::const_iterator ite = vals_.begin();
			 ite != vals_.end(); ++ite)
		{
			T_ v = *ite;
			char* c = (char*)&v;
			if (SDL_BYTEORDER != SDL_BIG_ENDIAN) {
				for (size_t i = 0; i < sizeof(T_); i++) {
					os.put(c[i]);
				}
			}
			else {
				for (size_t i = sizeof(T_); i > 0; i--) {
					os.put(c[i-1]);
				}
			}
		}
	}

private:
	std::vector<T_> vals_;

};

template <typename T_>
class Replayer {
public:
	Replayer(const std::string& file) {
		std::ifstream is(file.c_str(), std::ios::binary);
		while(!is.eof()) {
			T_ v;
			char* c = (char*)&v;

			if (SDL_BYTEORDER != SDL_BIG_ENDIAN) {
				for (size_t i = 0; i < sizeof(T_); i++) {
					is.get(c[i]);
				}
			}
			else {
				for (size_t i = sizeof(T_); i > 0; i--) {
					is.get(c[i-1]);
				}
			}

			vals_.push_back(v);
		}
		ite_ = vals_.begin();
	}

	bool hasNext() const {
		return (ite_ != vals_.end());
	}

	T_ pop() {
		return *(ite_++);
	}

private:
	std::vector<T_> vals_;
	typename std::vector<T_>::iterator ite_;

};

#endif // ! REPLAYER_H_
