#ifndef BOHA_REPLAY
#define BOHA_REPLAY

#include "replayer.h"

#include <string>
#include <memory>
#include <cstdlib>

int rnd(int x);
double rnd(double x);

class Replay {
public:
	Replay();

	void load(const std::string& inputFile, const std::string& rndFile,
			  const std::string& rndMaxFile, const std::string& bulletsFile);
	void save(const std::string& inputFile, const std::string& rndFile,
			  const std::string& rndMaxFile, const std::string& bulletsFile);

	void pushInput(char v) { inputRec_.push(v); }
	void pushRnd(int v) { rndRec_.push(v); }
	char popInput() { return inputRep_->pop(); }
	int popRnd() { return rndRep_->pop(); }

	bool hasNext() const { return inputRep_->hasNext() && rndRep_->hasNext(); }

	int rndMax() const { return rndMax_; }
	int bullets() const { return bullets_; }

private:
	Recorder<char> inputRec_;
	Recorder<int> rndRec_;
	std::auto_ptr<Replayer<char> > inputRep_;
	std::auto_ptr<Replayer<int> > rndRep_;

	int rndMax_;
	int bullets_;

};

double rep_rec_rand();

#endif // ! BOHA_REPLAY
