#include "replay.h"
#include "conf.h"
#include "game.h"
#include "bulletinfo.h"

int rnd(int x) { return static_cast<int>(x*rep_rec_rand()); }
double rnd(double x) { return x*rep_rec_rand(); }

double rep_rec_rand() {
	int ret;
	Replay* rep = Game::instance()->getReplay();
	if (Conf::instance()->isReplay()) {
		ret = rep->popRnd();
	}
	else {
		ret = std::rand();
	}
	rep->pushRnd(ret);
	return (double)ret / rep->rndMax();
}

Replay::Replay()
	: rndMax_(RAND_MAX),
	  bullets_(Game::instance()->getBulletInfo()->getBulletNum())
{}

void Replay::load(const std::string& inputFile, const std::string& rndFile,
				  const std::string& rndMaxFile,
				  const std::string& bulletsFile)
{
	inputRep_.reset(new Replayer<char>(inputFile));
	rndRep_.reset(new Replayer<int>(rndFile));
	std::ifstream is(rndMaxFile.c_str());
	is >> rndMax_;
	std::ifstream is2(bulletsFile.c_str());
	if (is2.is_open()) {
		is2 >> bullets_;
	}
	else {
		bullets_ = Game::instance()->getBulletInfo()->getBulletNum();
	}
}

void Replay::save(const std::string& inputFile, const std::string& rndFile,
				  const std::string& rndMaxFile,
				  const std::string& bulletsFile) {
	inputRec_.save(inputFile);
	rndRec_.save(rndFile);
	std::ofstream os(rndMaxFile.c_str());
	os << rndMax_;
	std::ofstream os2(bulletsFile.c_str());
	os2 << bullets_;
}

