#ifndef BOHA_PLAYER
#define BOHA_PLAYER

#include "char.h"
#include "mysdl_padinput.h"

class CpuInput;

class Player : public Charactor {
public:
    Player (const Point& pnt, Surface* graph, MSDL::InputBase& inputMgr);
    virtual ~Player();

    void keyEvent ();

    virtual void hit (Charactor* bc) { bc->hitByPlayer(this); }
    virtual void hitByPlayer (Player* bc);
    virtual void hitByEnemy (Enemy* bc);
    virtual void hitByShot (Shot* bc);

    Point upperPoint() const {
		return surface_->size() - graph_->size();
    }

private:
    void shot() const;

    double prevShotTurn_;

    double pow_;

    MSDL::InputBase& inputMgr_;
};

#endif // ! BOHA_PLAYER
