#include "player.h"
#include "enemy.h"
#include "conf.h"
#include "game.h"
#include "shot.h"
#include "replay.h"

Player::Player (const Point& pnt, Surface* graph, MSDL::InputBase& inputMgr)
    : Charactor(pnt, graph), pow_(100), inputMgr_(inputMgr) {
	zako_ = false;
}

void Player::hitByPlayer (Player*) {
	assert(0);
}

void Player::hitByEnemy (Enemy* bc) {
    if (center().length(bc->center()) < Conf::instance()->playerSize())
		if (!Conf::instance()->watch())
			Game::instance()->end();
}

void Player::hitByShot (Shot* bc) {
    if (center().length(bc->center()) < Conf::instance()->playerSize())
		if (!Conf::instance()->watch())
			Game::instance()->end();
}

void Player::shot() const{
}

void Player::keyEvent() {
	spd_ = Point(0, 0);

	SDL_PumpEvents();

	double base;

	bool button;
	MSDL::Axis axis;
	if (Conf::instance()->isReplay()) {
		int code = Game::instance()->getReplay()->popInput();
		button = code & 16;
		axis = MSDL::Axis(code & 15);
	}
	else {
		button = inputMgr_.getButton(0);
		axis = inputMgr_.getAxis();
	}

	if (button) base = Conf::instance()->playerSpeed2();
	else base = Conf::instance()->playerSpeed();
	double cross = base / SQRT_TWO;

	if (axis == MSDL::Axis::UP)     spd_.y = -base;
	else if (axis == MSDL::Axis::RIGHT) spd_.x = base;
	else if (axis == MSDL::Axis::DOWN) spd_.y = base;
	else if (axis == MSDL::Axis::LEFT) spd_.x = -base;
	else if (axis == MSDL::Axis::UPRIGHT) {
		spd_.x = cross;
		spd_.y = -cross;
	}
	else if (axis == MSDL::Axis::DOWNRIGHT) {
		spd_.x = cross;
		spd_.y = cross;
	}
	else if (axis == MSDL::Axis::DOWNLEFT) {
		spd_.x = -cross;
		spd_.y = cross;
	}
	else if (axis == MSDL::Axis::UPLEFT) {
		spd_.x = -cross;
		spd_.y = -cross;
	}

	char v = axis.getAxisCode();
	if (button) v |= 16;
	Game::instance()->getReplay()->pushInput(v);
}

Player::~Player() {}

