/// ͂i
/**
 * L[{[hƃWCXeBbN
 * lƃ{^ō\͂i
 */

#ifndef __MYSDL_PADINPUT_H__
#define __MYSDL_PADINPUT_H__

#include "mysdl_error.h"
#include "mysdl_joystick.h"
#include "cpputil.h"

#include <singleton.h>

#include <SDL.h>

#include <vector>
#include <memory>
#include <utility>
#include <map>

namespace MSDL {

	class Axis {
	public:
		static const int NONE;
		static const int UP;
		static const int UPRIGHT;
		static const int RIGHT;
		static const int DOWNRIGHT;
		static const int DOWN;
		static const int DOWNLEFT;
		static const int LEFT;
		static const int UPLEFT;

	public:
		Axis() : axis_(NONE) {}
		explicit Axis(int axis) : axis_(axis) {}

	public:
		void add(int axis) { axis_ |= axis; }
		void add(Axis axis) { add(axis.axis_); }

	public:
		std::string getName() const;

	public:
		int getAxisCode() const { return axis_; }
		int getSmallAxisCode() const;
		static Axis createFromSmallCode(int code);

		Axis getOpposite() const {
			int axis = axis_;
			if (isUp()) axis += 1;
			else if (isDown()) axis -= 1;
			if (isRight()) axis += 4;
			else if (isLeft()) axis -= 4;
			return Axis(axis);
		}

		Axis getRotatedRight(int n =1) const {
			Axis ret;
			for (int i = 0; i < n; i++) {
				if (axis_ == NONE) ret = Axis(NONE);
				else if (axis_ == UP) ret = Axis(UPRIGHT);
				else if (axis_ == UPRIGHT) ret = Axis(RIGHT);
				else if (axis_ == RIGHT) ret = Axis(DOWNRIGHT);
				else if (axis_ == DOWNRIGHT) ret = Axis(DOWN);
				else if (axis_ == DOWN) ret = Axis(DOWNLEFT);
				else if (axis_ == DOWNLEFT) ret = Axis(LEFT);
				else if (axis_ == LEFT) ret = Axis(UPLEFT);
				else if (axis_ == UPLEFT) ret = Axis(UP);
				else throw Error("getRotatedRight: broken axis.");
			}
			return ret;
		}
		Axis getRotatedLeft(int n =1) const {
			Axis ret;
			for (int i = 0; i < n; i++) {
				if (axis_ == NONE) ret = Axis(NONE);
				else if (axis_ == UP) ret = Axis(UPLEFT);
				else if (axis_ == UPRIGHT) ret = Axis(UP);
				else if (axis_ == RIGHT) ret = Axis(UPRIGHT);
				else if (axis_ == DOWNRIGHT) ret = Axis(RIGHT);
				else if (axis_ == DOWN) ret = Axis(DOWNRIGHT);
				else if (axis_ == DOWNLEFT) ret = Axis(DOWN);
				else if (axis_ == LEFT) ret = Axis(DOWNLEFT);
				else if (axis_ == UPLEFT) ret = Axis(LEFT);
				else throw Error("getRotatedLeft: broken axis.");
			}
			return ret;
		}

	public:
		bool operator == (Axis rhs) const { return axis_ == rhs.axis_; }
		bool operator != (Axis rhs) const { return axis_ != rhs.axis_; }
		bool operator == (int rhs) const { return axis_ == rhs; }
		bool operator != (int rhs) const { return axis_ != rhs; }
		friend inline bool operator == (int lhs, Axis rhs) {
			return rhs == lhs;
		}
		friend inline bool operator != (int lhs, Axis rhs) {
			return rhs != lhs;
		}
		
		Axis& operator = (int rhs) {
			axis_ = rhs;
			return *this;
		}

	public:
		bool isRight() const {
			return axis_ & 4;
		}
		bool isLeft() const {
			return axis_ & 8;
		}
		bool isDown() const {
			return axis_ & 2;
		}
		bool isUp() const {
			return axis_ & 1;
		}
		bool isXAxis() const {
			return isRight() || isLeft();
		}
		bool isYAxis() const {
			return isUp() || isDown();
		}

	private:
		int axis_;
	};

    /// {^͊NX
	class ButtonInput {
	public:
		virtual bool getButton() =0;
		virtual std::string getName() const =0;
	};

    /// L[{[hɂ{^̓NX
	class KeyButtonInput : public ButtonInput {
	public:
		KeyButtonInput(SDLKey key) : key_(key) {}
		virtual bool getButton() { return SDL_GetKeyState(0)[key_]; }

		virtual std::string getName() const;

	private:
		SDLKey key_;
	};

    /// WCXeBbNɂ{^̓NX
	class JoystickButtonInput : public ButtonInput {
	public:
		JoystickButtonInput(int index, int button)
			: joystick_(JoystickMgr::instance()->getJoystick(index)),
		  button_(button) {
			checkError(joystick_ != 0,
					   std::string(
						   "JoystickButtonInput::JoystickButtonInput:") +
					   "bad joystick index.");
		}
		virtual bool getButton() {
			return joystick_->getButton(button_); 
		}

		virtual std::string getName() const;

	private:
		Joystick* joystick_;
		int button_;
	};

    /// WCXeBbN̕{^ɂ{^̓NX
	class JoystickAxisButtonInput : public ButtonInput {
	public:
		static const int JOYSTICK_PLAY_WIDTH;

	public:
		/**
		 * @param axis ΂ߕw肵Ă͂ȂȂB
		 */
		JoystickAxisButtonInput(int index, Axis axis)
			: joystick_(JoystickMgr::instance()->getJoystick(index)),
           axis_(axis)
			{
				checkError(joystick_ != 0,
						   std::string("JoystickAxisButtonInput::JoystickAxisButtonInput: bad joystick index."));
					   }
		virtual bool getButton();

		virtual std::string getName() const;
	public:
		/// SDL X^C̕\ MSDL X^Cɕϊ
		static Axis generateAxis(Uint8 axis, Sint16 value);

	private:
		Joystick* joystick_;
		Axis axis_;
	};

	class AxisInput {
	public:
		virtual Axis getAxis() =0;
		virtual ~AxisInput() {}
	};

    /// ButtonInput ɂ̓NX
	class ButtonAxisInput : public AxisInput {
	public:
		ButtonAxisInput() {}
		ButtonAxisInput(std::auto_ptr<ButtonInput> up,
						std::auto_ptr<ButtonInput> right,
						std::auto_ptr<ButtonInput> down,
						std::auto_ptr<ButtonInput> left)
			{
				up_.push_back(up.release());
				right_.push_back(right.release());
				down_.push_back(down.release());
				left_.push_back(left.release());
			}
		virtual ~ButtonAxisInput() {
			delete_clear(up_);
			delete_clear(right_);
			delete_clear(down_);
			delete_clear(left_);
		}

		virtual Axis getAxis();

		void setUpAxis(std::auto_ptr<ButtonInput> button) {
			up_.push_back(button.release());
		}
		void setRightAxis(std::auto_ptr<ButtonInput> button) {
			right_.push_back(button.release());
		}
		void setDownAxis(std::auto_ptr<ButtonInput> button) {
			down_.push_back(button.release());
		}
		void setLeftAxis(std::auto_ptr<ButtonInput> button) {
			left_.push_back(button.release());
		}

	private:
		std::vector<ButtonInput*> up_, right_, down_, left_;

	};

    /// ͏zNX
	class InputBase {
	public:
		virtual ~InputBase() {};

		virtual Axis getAxis() =0;
		virtual bool getButton(int id) =0;

		/// ܂ɓK
		typedef std::map<int, bool> AllButton;
		typedef std::auto_ptr<AllButton> AllButtonPtr;
		virtual AllButtonPtr getAllButton();

		virtual bool getAny();
		virtual bool getAnyButton();

	protected:
		/// ftHg getAllButton gƂ͂ ID B
		std::vector<int> buttons_;
	};

	/// ̓NX
	class Input : public InputBase {
	private:
		typedef std::multimap<int, ButtonInput*> ButtonMap;

	public:
		virtual ~Input() {
			for (std::map<int, ButtonInput*>::iterator ite =
					 buttonMap_.begin();
				 ite != buttonMap_.end(); ite++)
			{
				delete ite->second;
			}
			delete_clear(axis_);
		};

		void setAxis(std::auto_ptr<AxisInput> axis) {
			axis_.push_back(axis.release());
		}
		virtual Axis getAxis();

		void setButton(int id, std::auto_ptr<ButtonInput> button) {
			buttonMap_.insert(std::make_pair(id, button.release()));
		}
		virtual bool getButton(int id);

		virtual AllButtonPtr getAllButton();

	private:
		std::vector<AxisInput*> axis_;
		ButtonMap buttonMap_;
	};

	/// ͂̏ԂۑNX
	class InputState : public InputBase {
	public:
		explicit InputState(InputBase& input);

		virtual Axis getAxis() { return axis_; }
		virtual bool getButton(int id);

		virtual AllButtonPtr getAllButton();

	protected:
		Axis axis_;
		AllButtonPtr buttonMap_;

	};

	/// ͌n
	class InputMgr : public Input {
	public:
		virtual ~InputMgr();

		void setDevice(std::auto_ptr<InputBase> input);

		virtual Axis getAxis();
		virtual bool getButton(int id);

		virtual AllButtonPtr getAllButton();

	protected:
		std::vector<InputBase*> inputs_;
	};

	/// ݒt@CǂŃNX𐶐B
	/**
	 * @todo ȂƂЂǂł΂B
 	 */
	std::auto_ptr<Input> generateInputFromConf(const std::string& filename);

	/// {^͂҂AButtonInput𓾂
	/**
	 * SDL_QUIT NULLԂ
	 */
	std::auto_ptr<ButtonInput> generateAnyButtonInput();

	/// 񂩂ButtonInput𓾂
	std::auto_ptr<ButtonInput>
	generateButtonInputFromString(const std::string& str);

	/// wp
	//@{
	std::auto_ptr<AxisInput> generateKeyAxis();
	std::auto_ptr<AxisInput> generateJoyAxis(int index);
	//@}

}

#endif // ! __MYSDL_PADINPUT_H__
