/// WCXeBbNi
/**
 * {Iɂ͔bp
 * WCXeBbNĂ邩ȂCɂɎg
 */

#ifndef __MYSDL_JOYSTICK_H__
#define __MYSDL_JOYSTICK_H__

#include "mysdl_error.h"

#include "cpputil.h"

#include <vector>
#include <iostream>

#include <singleton.h>

#include <SDL.h>

namespace MSDL {

class Joystick {
public:
	explicit Joystick(int index) {
		joystick_ = SDL_JoystickOpen(index);
		if (joystick_ != 0) std::cout << "success open joystick " <<
								index << std::endl;
		else std::cout << "failed open joystick " << index << std::endl;
	}
	~Joystick() {
		if (isInited()) SDL_JoystickClose(joystick_);
	}

	bool isInited() const { return joystick_ != 0; }

	Sint16 axis(int axis) const {
		return SDL_JoystickGetAxis(const_cast<SDL_Joystick*>(joystick_), axis);
	}
	Sint16 axisX() const {
		return axis(0);
	}
	Sint16 axisY() const {
		return axis(1);
	}

	Uint8 getButton(int button) const {
		return 1 == SDL_JoystickGetButton(const_cast<SDL_Joystick*>(joystick_),
										  button);
	}

private:
	SDL_Joystick* joystick_;

};

class JoystickMgr : public Singleton<JoystickMgr> {
public:
	/**
	 * @return
	 * G[̏ꍇ 0 ԂB
	 * ́AJoystick  open łȂƂ邩Ǝv
	 */
	Joystick* getJoystick(int index) {
		checkInit();

		if (!inited_) return 0;

		checkJoysticksSize(index);

		if (joysticks_[index] == 0) {
			joysticks_[index] = new Joystick(index);
		}

		if (joysticks_[index]->isInited()) {
			return joysticks_[index];
		}
		else {
			return 0;
		}
	}

	~JoystickMgr() {
		delete_clear(joysticks_);
	}

private:
	void checkJoysticksSize(unsigned int index) {
		if (joysticks_.size() <= index) {
			joysticks_.resize(index+1, 0);
		}
	}

	void checkInit() {
		inited_ = true;
		if (!SDL_WasInit(SDL_INIT_JOYSTICK)) {
			SDL_InitSubSystem(SDL_INIT_JOYSTICK);
			std::cout << "joystick inited." << std::endl;
		}
	}

private:
	bool inited_;
	std::vector<Joystick*> joysticks_;

};

}

#endif // ! __MYSDL_JOYSTICK_H__
