/// SDL's Error API's wrapper

#ifndef __MYSDL_ERROR_H__
#define __MYSDL_ERROR_H__

#include <stdexcept>
#include <string>

#include <SDL.h>

namespace MSDL {
    class Error : public std::runtime_error {
    public:
	Error(const std::string& str)
	    : std::runtime_error(str) {}
    };

	/// ̓CuR[h
	//@{

#ifndef MYSDL_NDEBUG
    /// throw exception if SDL_GetError returns not NULL
    inline void checkSDLError() {
		if (SDL_GetError() != 0) {
			throw Error(SDL_GetError());
		}
    }
	/// throw exception if bool check is false
	inline void checkError(bool check, const std::string& str) {
		if (!check) {
			throw Error(str);
		}
	}
#else
	#define checkSDLError() ;
	#define checkError(expr1, expr2) ;
#endif
    /// throw exception
    inline void throwError() {
		if (SDL_GetError() != 0) {
			throw Error(SDL_GetError());
		}
		throw Error("unknown SDL's error.");
    }
    /// throw exception
    inline void throwError(const std::string& str) {
		throw Error(str);
    }

	//@}

} // namespace MSDL

#endif // ! __MYSDL_ERROR_H__
