#ifndef BOHA_GAME
#define BOHA_GAME

#include "singleton.h"
#include "mysdl_padinput.h"
#include "enemy.h"
#include "fpstimer.h"

#include "config.h"

#include <list>
#include <vector>
#include <queue>
#include <sstream>

#include <SDL.h>
#include <SDL_kanji_f1b/SDL_kanji.h>

#include <boost/smart_ptr.hpp>

class Screen;
class Surface;
class Charactor;
class Player;
class Enemy;
class Shot;
class EnemyCommand;
class BulletMLState;
class BulletInfo;
class BulletDescription;
class Select;
class Replay;
class CpuInputBase;

class Game : public Singleton<Game> {
public:
    Game();

    // ԂI
    int title();
    void init();
    void reinit();
    void enemyInit();
    int start();

	double spf() const { return spf_; }
    int shotNum() const { return shot_.size(); }
	int getFrameTurn() const;
	int getTurn() const;

    ~Game();

    const Player* player() const { return player_; }

    void addShot(const Point& pnt, const Point& spd, const Enemy* enemy);
    void addEnemy(const Point& pnt, const Point& spd, BulletMLState* state,
				  const Enemy* enemy);
#ifdef HAVE_LUA
    void addEnemy(const Point& pnt, const Point& spd, struct lua_State* state,
				  const char* func, const Enemy* enemy, int id = -1);
#endif
    bool isStart() const { return start_; }
    bool isEnd() const { return end_; }
    bool isQuit() const { return quit_; }
    void end() { end_ = true; }
    void quit() { quit_ = true; }

    double getRank() const { return rank_; }

    void getEnemyPosAndSpd(std::vector<std::pair<Point, Point> >& out) const;

	Screen* screen() { return screen_; }
	Surface* mainFrame();

	bool screenIsLarge() const;

	Kanji_Font* getFont() { return font_; }

	int waitAnyInput();
	int getAnyInput();
	void waitInputRelease();

	void endEv();

	void switchScreenMode(bool large);

	BulletInfo* getBulletInfo() { return bulletInfo_.get(); }

	void noticeChangeBullet(int index);

	int getLimit() const {
		return static_cast<int>((rank_+enemyNum_-1) * 100);
	}

	Replay* getReplay() { return replay_.get(); }
	void saveReplay(const std::string& c);
	void loadReplay(const std::string& prefix);

	void setNowBullet(BulletDescription* desc) { nowBullet_ = desc; }

	const std::list<Shot*> getShots() const { return shot_; }
	const std::list<Enemy*> getEnemys() const { return enemy_; }

	class MSDL::InputBase* inputMgr() { return inputMgr_.get(); }

	void initBMP();

private:
    void timerEv();
    void playerEv();
    void enemyEv();
    void hitEv();
    void updateScreen();
    void clearScreen();
    void deadEv();
	void levelEv();
	void charMoveValue();
	void charWallEvent();
	void charMoveGraphic();

	void processRanking();

    Screen* screen_;
	std::auto_ptr<Surface> mainFrame_;

    Player* player_;
    std::list<Enemy*> enemy_;
    std::list<Shot*> shot_;
    std::list<Charactor*> chars_;

	std::auto_ptr<Surface> playerg_;
    std::auto_ptr<Surface> enemygBoss_, enemygZako_, enemygBullet_;
    std::auto_ptr<Surface> shotg_, shotg2_;

	double spf_;

    bool start_;
    bool end_;
	bool quit_;

    double rank_;
	int enemyNum_;

    std::auto_ptr<MSDL::InputBase> inputMgr_;
	std::auto_ptr<CpuInputBase> cpuInput_;

    EnemyMgr enemyMgr_;

	Kanji_Font* font_;

	std::auto_ptr<MSDL::JoystickMgr> joystickMgr_;

	std::auto_ptr<BulletInfo> bulletInfo_;
	BulletDescription* nowBullet_;

	FPSTimer timer_;
	static const double framePerSecond_;

	std::auto_ptr<Select> select_;

	int bulletInfoTicks_;
	int ellapsedSecOrRank_;

	std::auto_ptr<Replay> replay_;

	int lastEnemyTurn_;

};

#endif // BOHA_GAME
