#ifndef FPS_TIMER_H_
#define FPS_TIMER_H_

class FPSTimer {
public:
	FPSTimer();

	void start();
	void wait();

	void setFps(int fps);

	bool shouldSkip() const { return shouldSkip_; }

	int getTurn() const { return turns_; }
	int getDroppedTurn() const { return frameDropTurns_; }
	int getTrueFps() const {
		return (turns_ - frameDropTurns_) * 1000 / (ticks_ - startTicks_);
	}
	int getFps() const { return fps_; }
	int getEllapsedTicks() const { return ticks_ - startTicks_; }
	int getEllapsedSecond() const { return getEllapsedTicks() / 1000; }

private:
	int startTicks_;
	int fps_;
	int ticksPerFrame_;
	int ticks_;
	bool shouldSkip_;
	int turns_;
	int frameDropTurns_;
    int prevDrawTicks_;

};

#endif // ! FPS_TIMER_H_

