#include "fpstimer.h"

#include <SDL.h>

FPSTimer::FPSTimer()
	: fps_(60), ticksPerFrame_(1000 / 60), shouldSkip_(false),
	  turns_(0), frameDropTurns_(0), prevDrawTicks_(0)
{}

void FPSTimer::setFps(int fps) {
	fps_ = fps;
	ticksPerFrame_ = 1000 / fps;
}

void FPSTimer::start() {
	startTicks_ = ticks_ = SDL_GetTicks();
}

void FPSTimer::wait() {
	ticks_ += ticksPerFrame_;

	shouldSkip_ = false;
	turns_++;

	int now = SDL_GetTicks();
	if (ticks_ < now) {
		if (prevDrawTicks_ > now - 100) {
			frameDropTurns_++;
			shouldSkip_ = true;
		}
		else {
			prevDrawTicks_ = now;
		}
		return;
	}

	prevDrawTicks_ = now;
	SDL_Delay(ticks_ - now);
}
