#ifndef BOHA_ENEMY
#define BOHA_ENEMY

#include "config.h"
#include "util.h"
#include "char.h"

#include <vector>
#include <string>

#include <SDL.h>

#include <boost/smart_ptr.hpp>

class EnemyCommand;
class BulletMLState;
class BulletMLParser;
class Enemy;

class EnemyBehavior {
public:
    explicit EnemyBehavior(std::istream& is);
    explicit EnemyBehavior(const std::string& filename);

    ~EnemyBehavior();

    std::auto_ptr<EnemyCommand> getRandomAction(Enemy* ene);
    std::auto_ptr<EnemyCommand> getNextAction(Enemy* ene);
    bool isRandomAction() const {
		return commandType_ == Random;
    }
    bool isListAction() const {
		return commandType_ == List;
    }

    void init();

	int getBulletNumber();

private:
    void parseActionFile(std::istream& is);

    typedef std::vector<BulletMLParser*> Commands;
    Commands commands_;
    Commands::iterator commandIte_;
    enum {List, Random} commandType_;

	int num_;

	std::vector<int> numberMap_;

#ifdef HAVE_LUA
	// too ad-hoc
	bool lua_;
	std::string filename_;
	std::string luaScript_;
#endif

};

/// G̃NX
class Enemy : public Charactor {
public:
    Enemy (const Point& pnt, const Point& spd, Surface* graph,
		   BulletMLState* state, bool blue);
#ifdef HAVE_LUA
    Enemy (const Point& pnt, const Point& spd, Surface* graph,
		   struct lua_State* state, const char* func, bool blue, int id);
#endif
    virtual ~Enemy();

    void huntEvent ();

    virtual void hit (Charactor* bc) { bc->hitByEnemy(this); }
    virtual void hitByPlayer (Player* bc);
    virtual void hitByEnemy (Enemy* bc);
    virtual void hitByShot (Shot* bc);

	bool blue() const { return blue_; }

protected:
    Enemy(const Point& pnt, Surface* graph);

private:
	virtual void endBullet() {}
	virtual void nextBullet() {}

protected:
    std::auto_ptr<EnemyCommand> com_;

	BulletMLState* state_;

	bool blue_;

    // R}h̎ۂ̑쌠͈ϏĂ܂
    friend class EnemyCommandBulletML;
#ifdef HAVE_LUA
    friend class EnemyCommandLua;
#endif
};

/// Boss
class BossEnemy : public Enemy {
public:
    BossEnemy(const Point& pnt, Surface* graph,
			  EnemyBehavior* behavior);

private:
	virtual void endBullet();
	virtual void nextBullet();

private:
    EnemyBehavior* behavior_;
	Point firstPnt_;
	int waitTime_;

};

class EnemyMgr {
public:
    EnemyMgr();

    void init();

    EnemyBehavior* getBehavior();

protected:
    // GĈƂɂgȂ
    std::auto_ptr<EnemyBehavior> behavior_;

};

#endif // ! BOHA_ENEMY
