#include "game.h"
#include "conf.h"
#include "screen.h"
#include "usererror.h"

#include <bulletml/bulletmlerror.h>

#include <stdexcept>
#include <iostream>

#ifdef BORLAND
#include <windows.h>
#include <dir.h>
#endif

void displayError(const std::string& msg, const std::string& kind) {
	Screen* scr = Game::instance()->screen();

	scr->fill(Color::BLACK);

	scr->putString(kind + "G[܂B",
				   Point(0, 50), Color::WHITE);

	size_t l = msg.find(": ");
	if (l != std::string::npos) {
		int cnt = 0;
		std::string m = msg;
		while (l != std::string::npos) {
			scr->putString(m.substr(0, l+1),
						   Point(0, 90+cnt*20), Color::WHITE);
			m = m.substr(l+1);
			l = m.find(": ");
			cnt++;
		}
		scr->putString(m, Point(0, 90+cnt*20), Color::WHITE);
	}
	else {
		scr->putString(msg, Point(0, 125), Color::WHITE);
	}

	scr->putString("{^ƏI܂B",
				   Point(0, 200), Color::WHITE);
	scr->putString("Ȃ̃G[ɐS肪΁A",
				   Point(0, 250), Color::WHITE);
	scr->putString("҂ɘAĒƍKłB",
				   Point(0, 300), Color::WHITE);
	scr->putString("  shinichiro.h (s31552@mail.ecc.u-tokyo.ac.jp)",
				   Point(0, 350), Color::WHITE);

	scr->flip();

	SDL_Delay(1000);

	Game::instance()->waitInputRelease();
	Game::instance()->waitAnyInput();

}

int main(int argc, char* argv[]) {
#ifdef BORLAND
	HKEY key;
	if (ERROR_SUCCESS == RegOpenKeyEx(HKEY_CLASSES_ROOT,
									  "bml_auto_file\\Shell\\open\\command",
									  0, KEY_QUERY_VALUE, &key))
	{
		char buf[4096];
		DWORD x = 4096;
		RegQueryValueEx(key, "", 0, 0, (BYTE*)buf, &x);
		std::string exe(buf);
		std::string dir(exe.substr(0, exe.find_last_of("\\")));
		chdir(dir.c_str());
	}
#endif
#ifdef MACOSX
    chdir("sdmkun.app/Contents/Resources");
#endif

	Game* game = new Game;

	try {
		new Conf(argc, argv);

		game->init();

		int ret = 0;
		while (ret == 0) {
			ret = game->title();
			if (0 == ret) ret = game->start();
			if (0 == ret) game->reinit();
		}

		delete game;

		return 0;
	}
	catch (BulletMLError be) {
		std::cerr << "BulletML Error occured" << std::endl;
		std::cerr << be.what() << std::endl;

		displayError(be.what(), "BulletML");

		delete game;
		return 1;
	}
	catch (UserError ue) {
		std::cerr << "UserError occured" << std::endl;
		std::cerr << ue.what() << std::endl;

		displayError(ue.what(), "User");

		delete game;
		return 1;
	}
	catch (std::runtime_error re) {
		std::cerr << re.what() << "\n";
		std::cerr << "SDL: " << SDL_GetError() << "\n";

		displayError(re.what(), "unknown runtime");

		delete game;
		return 1;
	}
	catch (...) {
		std::cerr << "unknown exception.\n";

		displayError("", "悭킩ȂG[łB");

		delete game;
		return 1;
	}
}
