/**
 * $Id: dir_ite.h,v 1.2 2003/10/13 22:54:34 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef dir_ite_h_
#define dir_ite_h_

#include <vector>
#include <string>

/**
 * fBNg̑St@C邱ƂlĂȂB
 * ŏ\ȃV[ł̂ݎgB
 */
class Dir {
public:
	explicit Dir(std::string path);

	const std::string& path() const { return path_; }

public:
	typedef std::vector<std::string>::const_iterator iterator;

	iterator begin() const { return iterator(files_.begin()); }
	iterator end() const { return iterator(files_.end()); }

	std::string full(std::string file) const {
		//debug_out( path_ + "/" + file);
		return path_ + "/" + file;
	}

private:
	std::string path_;
	std::vector<std::string> files_;

};

#endif // ! dir_ite_h_

