#ifndef BOHA_DESIGNER
#define BOHA_DESIGNER

#include "util.h"

#include <string>
#include <vector>
#include <memory>

class Screen;
class Surface;

/// Select ł邩炻̏ꂵ̂ōNXB
class Designer {
public:
	Designer();
	void initBMP();

	void putDimmedString(const std::string& str, const Point& pnt,
						 const Color& col, Surface* screen = 0);
	void putDimmedRect(int x, int y, int w, int h, const Color& col);
	void putDimmedRect(const Rect& r, const Color& col) {
		putDimmedRect(r.x(), r.y(), r.w(), r.h(), col);
	}
	void putStringList(const std::vector<std::string>& strs,
					   const Point& pnt, int yspace,
					   size_t cols = 99, size_t scroll = 0);
	void putStringListAndRect(const std::vector<std::string>& strs,
							  const Point& pnt, int yspace,
							  int xmargin, int ymargin,
							  size_t cols = 99, size_t scroll = 0);
	int getStringMaxWidth(const std::vector<std::string>& strs);
	int getStringHeight(int yspace, size_t cols);
	void putInfoFrames();
	void putParagraph(const Rect& r, const std::string& str, size_t x);

	Rect getDimmedRect(const Rect r) {
		return Rect(r.x()-DIM-2, r.y()-DIM-2, r.x2()+DIM+2, r.y2()+DIM+2);
	}

	void putLogo();

public:
	static const int MARGIN;
	static const int DIM;
	static const int RECMARGIN;

protected:
	Screen* screen_;
	std::auto_ptr<Surface> logo_;

};

#endif // ! BOHA_DESIGNER

