#include "designer.h"
#include "game.h"
#include "conf.h"
#include "surface.h"
#include "screen.h"

// gcc ł isprint  std ȂBԂ}N̂B
// WێȒP gcc Œʂɂ c o[W
// #include ȂȂƎvB
#include <ctype.h>

const int Designer::MARGIN = 12;
const int Designer::DIM = 2;
const int Designer::RECMARGIN = MARGIN - DIM - 1;

Designer::Designer()
	: screen_(Game::instance()->screen())
{
	screen_ = Game::instance()->screen();
	initBMP();
}

void Designer::initBMP() {
	std::string bmp = Conf::instance()->bmpdir();
	logo_.reset(new Surface(bmp+"/logo.bmp"));
}

void Designer::putDimmedString(const std::string& strsrc, const Point& p,
							   const Color& col, Surface* screen)
{
	std::string str(strsrc);
	if (!Conf::instance()->english()) {
		size_t index = str.find('(');
		if (index != std::string::npos) {
			str.erase(index);
		}
	}

	if (screen == 0) screen = screen_;

	if (Conf::instance()->dimmed()) {
		std::vector<Color> dimmed;
		for (int i = 6; i >= 1; i--) {
			double r = i * 0.1;
			dimmed.push_back(Color((Uint8)(col.r()*r),
								   (Uint8)(col.g()*r), (Uint8)(col.b()*r)));
		}

		for (int index = DIM*2-1; index > 0; index--) {
			for (int y = -DIM; y <= DIM; y++) {
				int ay = std::abs(y);
				if (ay > index) continue;
				int x = index - ay;
				screen->putString(str, Point(p.xi()+x, p.yi()+y),
								  dimmed[index]);
				if (x != 0) {
					screen->putString(str, Point(p.xi()-x, p.yi()+y),
									  dimmed[index]);
				}
			}
		}
	}
	screen->putString(str, p, col);
}

void Designer::putDimmedRect(int bx, int by, int w, int h, const Color& col) {
	if (Conf::instance()->dimmed()) {
		std::vector<Color> dimmed;
		for (int i = 6; i >= 1; i--) {
			double r = i * 0.1;
			dimmed.push_back(Color((Uint8)(col.r()*r),
								   (Uint8)(col.g()*r), (Uint8)(col.b()*r)));
		}

		for (int index = DIM*2-1; index > 0; index--) {
			for (int y = -DIM; y <= DIM; y++) {
				int ay = std::abs(y);
				if (ay > index) continue;
				int x = index - ay;
				screen_->drawRect(Rect(bx+x, by+y, w, h, true), dimmed[index]);
				if (x != 0) {
					screen_->drawRect(Rect(bx-x, by+y, w, h, true),
									  dimmed[index]);
				}
			}
		}
	}
	screen_->drawRect(Rect(bx, by, w, h, true), col);
}

void Designer::putStringList(const std::vector<std::string>& strs,
						   const Point& pnt, int yspace,
						   size_t cols, size_t scroll)
{
	if (strs.empty()) return;

	size_t max = std::min(strs.size(), cols);
	for (size_t i = 0; i < max; i++) {
		Point p(pnt.xi(), pnt.yi() + yspace * i);
		putDimmedString(strs[i+scroll], p, Color::WHITE);
	}
}

int Designer::getStringMaxWidth(const std::vector<std::string>& strs) {
	size_t i, maxlen = 0;
	for (i = 0; i < strs.size(); i++) {
		maxlen = std::max(strs[i].length(), maxlen);
	}
	return maxlen * screen_->fontWidth();
}

int Designer::getStringHeight(int yspace, size_t cols) {
	return yspace * (cols-1) + screen_->fontHeight();
}

void Designer::putStringListAndRect(const std::vector<std::string>& strs,
								  const Point& pnt, int yspace,
								  int xmargin, int ymargin,
								  size_t cols, size_t scroll)
{
	putStringList(strs, pnt, yspace, cols, scroll);

	int stringWidth = getStringMaxWidth(strs);
	size_t max = std::min(strs.size(), cols);
	int x = pnt.xi() - xmargin;
	int y = pnt.yi() - ymargin;
	int w = stringWidth + xmargin * 2;
	int h = getStringHeight(yspace, max) + ymargin * 2;
	putDimmedRect(x, y, w, h, Color::WHITE);

}

void Designer::putLogo() {
	const Rect& r3 = Screen::PREVIEW_FRAME;
	screen_->blit(logo_.get(), r3.start()+Point(DIM-1, DIM+1));
}

void Designer::putInfoFrames() {
	const Rect& r1 = Screen::DESCRIPTION_FRAME;
	putDimmedRect(r1, Color::WHITE);

	const Rect& r2 = Screen::CAPTURE_FRAME;
	putDimmedRect(r2, Color::WHITE);

	const Rect& r3 = Screen::PREVIEW_FRAME;
	putDimmedRect(r3, Color::WHITE);
	putLogo();

	const Rect& r4 = Screen::PLAYERINFO_FRAME;
	putDimmedRect(r4, Color::WHITE);

	const Rect& r5 = Screen::STATUS_FRAME;
	putDimmedRect(r5, Color::WHITE);

}

void Designer::putParagraph(const Rect& r, const std::string& str, size_t x) {
	static const int yspace = 14;

	screen_->fillRect(Rect(r.x()+RECMARGIN, r.y()+RECMARGIN,
						   r.x2()-RECMARGIN, r.y2()-RECMARGIN), Color::BLACK);

	std::vector<std::string> strs;
	for (size_t index = 0; index < str.length(); index += x) {
		std::string now(str.substr(index, std::min(x, str.length()-index)));

		if (x < str.length() - index) {
			// ƗǂASY肻c
			size_t asciis = 0;
			for (size_t i = 0; i < now.length(); i++) {
				if (isprint((unsigned char)now[i])) {
					asciis++;
				}
				else {
					i++;
				}
			}

			if (asciis % 2 == 1) {
				now.erase(now.size()-1);
				index--;
			}
		}

		strs.push_back(now);
	}

	putStringList(strs, r.start() + Point(MARGIN, MARGIN), yspace);
}

