/**
 * $Id: veto.cc,v 1.7 2003/10/13 22:54:42 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "veto.h"

#include "util.h"
#include "cpuutil.h"

VetoCpu::VetoCpu() {
	name_ = "veto";
}

void VetoCpu::calc() {
	double size = info_->getPlayerSize();;
	double size2 = size * size;

	double spf = info_->getSpf();

	PosSpds posspd;
	info_->getBulletsPosAndSpd(posspd);

	const Point& mypnt = info_->getPlayerPnt();

	for (int i = 0; i < 9; i++) {
		Point pnt = getMovedPoint(mypnt, MSDL::Axis::createFromSmallCode(i));

		for (PosSpds::iterator ite = posspd.begin();
			 ite != posspd.end(); ++ite)
		{
			if (pnt.length2(ite->first+ite->second*spf) < size2) {
				evaluations_[i] = -10000;
				break;
			}
			if (pnt.length2(ite->first) < size2) {
				evaluations_[i] = -5000;
				break;
			}
		}
	}

/*
	if (std::count_if(evaluations_, evaluations_+9,
					  std::bind2nd(std::less<int>(), -1000)) >= 5)
	{
		message("ɂ");
	}
*/
}

