/**
 * $Id: oblivion.h,v 1.10 2003/10/13 22:54:42 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef oblivion_h_
#define oblivion_h_

#include "cpu.h"

#include <deque>

/// Yp
/**
 * @_êɓKASYB
 * e̔cA̒eڋ߂Oɏ炵A
 * ̒eYAlOB
 */
class OblivionCpu : public CpuInputBase {
public:
	OblivionCpu();

private:
	virtual void calc();
	virtual void registShot(const PosSpd& shot);

	virtual int getConfidence() const;

	void decideAxis();
	void updateMovingPlan(const PosSpd& pas);

private:
	bool isAxisOK(MSDL::Axis axis) const;
	bool meetWall() const;

private:
	MSDL::Axis movingAxis_;
	bool isMoving_;

	int firstFrame_;
	PosSpds samples_;

	int startMoveFrame_;
	int endMoveFrame_;

	int dangerFrame_;
	MSDL::Axis prevAxis_;

	std::deque<bool> handlables_;

private:
	/// W߂Tv̐
	static const size_t WAIT_SAMPLES;
    /// Tvs\łӎv܂ł̎
	static const int WAIT_FRAMES;
	/// ]Tēhbg
	static const int OVER_MOVE;
	/// e鎞Ԃ̊
	static const double WAIT_RATE;
	/// l@Ώۂɂe̎@ɑ΂px̌E
	static const double LIMIT_BULLET_ANGLE;
	/// Ǖt߂łƔfhbg
	static const int NEAR_WALL;
	/// e\ǂL
	static const size_t HANDLABLE_NUM;
	/// ōɎg鎞̒l
	static const int MAX_CONFIDENCE;

};

#endif // ! oblivion_h_

