/**
 * $Id: oblivion.cc,v 1.14 2003/10/13 22:54:41 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "oblivion.h"

#include "cpuutil.h"

#include <functional>
#include <algorithm>

#include <boost/functional.hpp>

const size_t OblivionCpu::WAIT_SAMPLES = 50;
const int OblivionCpu::WAIT_FRAMES = 10;
const int OblivionCpu::OVER_MOVE = 20;
const double OblivionCpu::WAIT_RATE = 2.0 / 3;
const double OblivionCpu::LIMIT_BULLET_ANGLE = dtor(5);
const int OblivionCpu::NEAR_WALL = 15;
const size_t OblivionCpu::HANDLABLE_NUM = 100;
const int OblivionCpu::MAX_CONFIDENCE = 50;

OblivionCpu::OblivionCpu()
	: movingAxis_(MSDL::Axis::NONE), isMoving_(false), firstFrame_(-1),
	  dangerFrame_(-1), prevAxis_(MSDL::Axis::NONE)
{
	decision_ = false;

	name_ = "oblivion";
}

bool OblivionCpu::isAxisOK(MSDL::Axis axis) const {
	if (prevAxis_ == MSDL::Axis::NONE) return true;

	MSDL::Axis opposite = axis.getOpposite();
	if (prevAxis_ == opposite ||
		prevAxis_ == opposite.getRotatedRight() ||
		prevAxis_ == opposite.getRotatedLeft())
	{
		return false;
	}

	return true;
}

void OblivionCpu::decideAxis() {
	const Point& pnt = info_->getPlayerPnt();

	const Point& upper = info_->getPlayerMaxPnt();

	// TvƎ@Ƃ̊px̕ςƂ
	Point averageVec(0, 0);
	for (size_t i = 0; i < samples_.size(); i++) {
		Point vec(pnt - samples_[i].first);
		averageVec += vec;
	}
	averageVec /= samples_.size();

	// l̂ǂꂪK؂ȊpxlāA
	// ̌LIB

	// 180xōlΗǂ
	if (averageVec.y < 0) averageVec = -averageVec;

	double angle = averageVec.angle();
	if (angle > PI_PER_8 * 11 || angle < PI_PER_8 * 5) {
		if (dangerFrame_ > lastTurn_) {
			if (!isAxisOK(MSDL::Axis(MSDL::Axis::UP)))
				movingAxis_ = MSDL::Axis::DOWN;
			else if (!isAxisOK(MSDL::Axis(MSDL::Axis::DOWN)))
				movingAxis_ = MSDL::Axis::UP;
		}

		if (movingAxis_ == MSDL::Axis::NONE) {
			movingAxis_ = (pnt.y > upper.y / 2)
				? MSDL::Axis::UP : MSDL::Axis::DOWN;
		}
	}
	else if (angle > PI_PER_8 * 9) {
		if (dangerFrame_ > lastTurn_) {
			if (!isAxisOK(MSDL::Axis(MSDL::Axis::UPLEFT)))
				movingAxis_ = MSDL::Axis::DOWNRIGHT;
			else if (!isAxisOK(MSDL::Axis(MSDL::Axis::DOWNRIGHT)))
				movingAxis_ = MSDL::Axis::UPLEFT;
		}

		if (movingAxis_ == MSDL::Axis::NONE) {
			int len1 = (int)std::min(pnt.x, pnt.y);
			int len2 = (int)std::min(upper.x-pnt.x,upper.y-pnt.y);
			movingAxis_ =
				(len1 > len2) ? MSDL::Axis::UPLEFT : MSDL::Axis::DOWNRIGHT;
		}
	}
	else if (angle > PI_PER_8 * 7) {
		if (dangerFrame_ > lastTurn_) {
			if (!isAxisOK(MSDL::Axis(MSDL::Axis::RIGHT)))
				movingAxis_ = MSDL::Axis::LEFT;
			else if (!isAxisOK(MSDL::Axis(MSDL::Axis::LEFT)))
				movingAxis_ = MSDL::Axis::RIGHT;
		}

		if (movingAxis_ == MSDL::Axis::NONE) {
			movingAxis_ = (pnt.x > upper.x / 2)
				? MSDL::Axis::LEFT : MSDL::Axis::RIGHT;
		}
	}
	else {
		if (dangerFrame_ > lastTurn_) {
			if (!isAxisOK(MSDL::Axis(MSDL::Axis::UPRIGHT)))
				movingAxis_ = MSDL::Axis::DOWNLEFT;
			else if (!isAxisOK(MSDL::Axis(MSDL::Axis::DOWNLEFT)))
				movingAxis_ = MSDL::Axis::UPRIGHT;
		}

		if (movingAxis_ == MSDL::Axis::NONE) {
			int len1 = (int)std::min(pnt.x, upper.y-pnt.y);
			int len2 = (int)std::min(upper.x-pnt.x, pnt.y);
			movingAxis_ =
				(len1 > len2) ? MSDL::Axis::DOWNLEFT : MSDL::Axis::UPRIGHT;
		}
	}

	// ǂɂԂĂꍇ
	if (movingAxis_ == MSDL::Axis::UPRIGHT) {
		if (pnt.y < NEAR_WALL) movingAxis_ = MSDL::Axis::RIGHT;
		else if (pnt.x > upper.x-NEAR_WALL)
			movingAxis_ = MSDL::Axis::UP;
	}
	else if (movingAxis_ == MSDL::Axis::UPLEFT) {
		if (pnt.y < NEAR_WALL) movingAxis_ = MSDL::Axis::LEFT;
		else if (pnt.x < NEAR_WALL)	movingAxis_ = MSDL::Axis::UP;
	}
	else if (movingAxis_ == MSDL::Axis::DOWNRIGHT) {
		if (pnt.y > upper.y-NEAR_WALL)
			movingAxis_ = MSDL::Axis::RIGHT;
		else if (pnt.x > upper.x-NEAR_WALL)
			movingAxis_ = MSDL::Axis::DOWN;
	}
	else if (movingAxis_ == MSDL::Axis::DOWNLEFT) {
		if (pnt.y > upper.y-NEAR_WALL)
			movingAxis_ = MSDL::Axis::LEFT;
		else if (pnt.x < NEAR_WALL)	movingAxis_ = MSDL::Axis::DOWN;
	}
	else if ((movingAxis_ == MSDL::Axis::UP && pnt.y < NEAR_WALL) ||
			 (movingAxis_ == MSDL::Axis::DOWN &&
			  pnt.y > upper.y-NEAR_WALL))
	{
		movingAxis_ = (pnt.x > upper.x / 2)
			? MSDL::Axis::LEFT : MSDL::Axis::RIGHT;
	}
	else if ((movingAxis_ == MSDL::Axis::LEFT && pnt.x < NEAR_WALL) ||
			 (movingAxis_ == MSDL::Axis::RIGHT &&
			  pnt.x > upper.x-NEAR_WALL))
	{
		movingAxis_ = (pnt.y > upper.y / 2)
			? MSDL::Axis::UP : MSDL::Axis::DOWN;
	}

	prevAxis_ = movingAxis_;

/*
	if (getConfidence() > 5) {
		message(getAxisString(movingAxis_));
	}
*/

	// ܂Ƃňړvł

	// v̏
	startMoveFrame_ = -1;
	endMoveFrame_ = -1;

	std::for_each(samples_.begin(), samples_.end(),
				  boost::bind1st(
					  std::mem_fun(&OblivionCpu::updateMovingPlan), this));

	// n
	samples_.clear();
	firstFrame_ = -1;

}

void OblivionCpu::updateMovingPlan(const PosSpd& pas) {
	int turn = (firstFrame_ == -1) ? lastTurn_ : firstFrame_;

	// ̒eȂʒu܂łɂ
	// ǂꂾ̎ԂłǂꂾΗǂ̂H

	// ܂]čWn킹
	Point vec(info_->getPlayerPnt() - pas.first);
	Point spd(pas.second);

	double rotAngle = - PI_PER_4 * (movingAxis_.getSmallAxisCode()-1);
	vec.rotate(rotAngle);
	spd.rotate(rotAngle);

	// ǂꂾԂ́B
	double collSecond = vec.x / spd.x;

	// ǂꂾΗǂ́B(炩]T)
	double safeLength = vec.y - spd.y * collSecond + OVER_MOVE;
	double safeSecond = safeLength / info_->getPlayerSpd();
	int safeFrame = static_cast<int>(safeSecond / info_->getSpf());

    // ɌꂽeAʂe͖B
	// ̔͂ƑׂȂB
	if (collSecond < 0 || collSecond < safeSecond) return;

	// ړJn𑁂߂邩B
	if (!isMoving_) {
		int newStartMoveFrame = turn
			+ static_cast<int>(
				(collSecond-safeSecond)*WAIT_RATE/info_->getSpf());
		if (startMoveFrame_ == -1 || startMoveFrame_ > newStartMoveFrame) {
			if (endMoveFrame_ != -1) {
				endMoveFrame_ += newStartMoveFrame - startMoveFrame_;
			}
			startMoveFrame_ = newStartMoveFrame;
		}
	}

	// ړIx߂邩B
	if (!isMoving_) {
		int newEndMoveFrame = startMoveFrame_ + safeFrame;
		if (endMoveFrame_ == -1 || endMoveFrame_ < newEndMoveFrame) {
			endMoveFrame_ = newEndMoveFrame;
		}
	}
	else {
		int newEndMoveFrame = turn + safeFrame;
		if (endMoveFrame_ < newEndMoveFrame) {
			endMoveFrame_ = newEndMoveFrame;
		}
	}

	// 댯Ix߂邩B
	int collFrame =
		static_cast<int>(collSecond / info_->getSpf()) + lastTurn_;
	if (dangerFrame_ == -1 || dangerFrame_ < collFrame) {
		dangerFrame_ = collFrame;
	}

}

bool OblivionCpu::meetWall() const {
	const Point& pnt = info_->getPlayerPnt();
	const Point& upper = info_->getPlayerMaxPnt();

	return (
		(movingAxis_.isUp() && pnt.y < NEAR_WALL) ||
		(movingAxis_.isDown() && pnt.y > upper.y-NEAR_WALL) ||
		(movingAxis_.isRight() && pnt.x > upper.x-NEAR_WALL) ||
		(movingAxis_.isLeft() && pnt.x < NEAR_WALL)
		);
}

void OblivionCpu::calc() {
	if (isMoving_) {
		// ړIȁB
		if (lastTurn_ > endMoveFrame_ || meetWall()) {
			movingAxis_ = MSDL::Axis::NONE;
			axis_ = MSDL::Axis::NONE;

			// Zbg
			firstFrame_ = startMoveFrame_ =	endMoveFrame_ =	-1;
			isMoving_ = false;
		}
	}
	// ܂ړ₪܂ĂȂ
	else if (movingAxis_ == MSDL::Axis::NONE) {
		// TvW܂邩AԂo߂ƈړ肷
		if (firstFrame_ != -1 && firstFrame_ + WAIT_FRAMES < lastTurn_) {
			decideAxis();
		}
	}
	// ړJn
	else if (lastTurn_ >= startMoveFrame_ && startMoveFrame_ != -1) {
		axis_ = movingAxis_;
		isMoving_ = true;
	}

	if (axis_ != MSDL::Axis::NONE) {
		evaluations_[axis_.getSmallAxisCode()] = 30;
		evaluations_[axis_.getRotatedLeft().getSmallAxisCode()] = 20;
		evaluations_[axis_.getRotatedRight().getSmallAxisCode()] = 20;
		evaluations_[axis_.getRotatedLeft(2).getSmallAxisCode()] = 10;
		evaluations_[axis_.getRotatedRight(2).getSmallAxisCode()] = 10;
		evaluations_[0] = 10;
	}


}

int OblivionCpu::getConfidence() const {
	if (handlables_.empty()) return 0;

	int ok = 0;
	for (std::deque<bool>::const_iterator ite = handlables_.begin();
		 ite != handlables_.end(); ++ite)
	{
		if (*ite) ok++;
	}

	return ok * MAX_CONFIDENCE / handlables_.size();
}

void OblivionCpu::registShot(const PosSpd& shot) {
	PosSpd pas(shot.first, shot.second);

	if (handlables_.size() == HANDLABLE_NUM) {
		handlables_.pop_back();
	}

	double angle = getShotAngle(shot);
	if (angle > LIMIT_BULLET_ANGLE) {
		handlables_.push_front(false);
		return;
	}

	handlables_.push_front(true);

	// ܂ړ₪܂ĂȂ
	if (movingAxis_ == MSDL::Axis::NONE) {
		if (firstFrame_ == -1) firstFrame_ = lastTurn_;

		// Tvo^
		samples_.push_back(pas);

		// TvW܂邩AԂo߂ƈړ肷
		if (samples_.size() == WAIT_SAMPLES) {
			decideAxis();
		}
	}
	else {
		updateMovingPlan(pas);
	}
}

