/**
 * $Id: inspection.h,v 1.2 2003/10/13 22:54:41 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef inspection_h_
#define inspection_h_

#include "cpu.h"

#include <SDL.h>

#include <memory>

/// @
/**
 * e̍@܂Bɂ͋͂܂B
 */
class InspectionCpu : public CpuInputBase {
public:
    InspectionCpu();

private:
	virtual void calc();
	virtual void registShot(const PosSpd& shot);
	virtual void registEnemy(const class Enemy* enemy);

	// ɎM̓[B
	virtual int getConfidence() const {	return 0; }

	std::auto_ptr<class BulletEvaluation> getReport() const;
	virtual void report() const;

private:
	Uint32 first_;

	int num_;
	int aimNum_;
	int bogoAimNum_;
	std::vector<double> speeds_;
	int enemyNum_;

private:
	/// S@_eK肷px
	static const double AIM_ANGLE;
	/// GcȎ@_eK肷px
	static const double BOGO_AIM_ANGLE;

};

#endif // ! inspection_h_

