/**
 * $Id: inspection.cc,v 1.2 2003/10/13 22:54:41 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */


#include "inspection.h"
#include "enemy.h"
#include "bullet_eval.h"

#include <numeric>
#include <cmath>

const double InspectionCpu::AIM_ANGLE = dtor(1);
const double InspectionCpu::BOGO_AIM_ANGLE = dtor(30);

InspectionCpu::InspectionCpu()
	: num_(0), aimNum_(0), bogoAimNum_(0), enemyNum_(0)
{
	name_ = "inspection";

	first_ = SDL_GetTicks();

	axis_ = MSDL::Axis::NONE;
}

void InspectionCpu::calc() {
    return;
}

void InspectionCpu::registShot(const PosSpd& shot) {
	num_++;

	double angle = getShotAngle(shot);
	if (angle < AIM_ANGLE) aimNum_++;
	if (angle < BOGO_AIM_ANGLE) bogoAimNum_++;

	speeds_.push_back(shot.second.length());
}

void InspectionCpu::registEnemy(const Enemy*) {
	num_++;
	enemyNum_++;

	/// @todo now cannot inspect...
}

std::auto_ptr<BulletEvaluation> InspectionCpu::getReport() const {
	std::auto_ptr<BulletEvaluation> eval(new BulletEvaluation());

	Uint32 now = SDL_GetTicks();
	Uint32 ellapsed = now - first_;

	if (num_ - enemyNum_ == 0) eval->aim = 0;
	else eval->aim = (aimNum_ + bogoAimNum_ / 5) * 100 / (num_ - enemyNum_);

	if (ellapsed == 0) eval->density = 0;
	else eval->density = num_ * 1000 / ellapsed;

	if (num_ == 0) eval->tricky = 0;
	else eval->tricky = enemyNum_ * 100 / num_;

	/// @todo ΂ׂc
	int speedAll = static_cast<int>(
		std::accumulate(speeds_.begin(), speeds_.end(), 0.0));
	if (num_ - enemyNum_ == 0) eval->speed = 0;
	else eval->speed = speedAll / 2 / (num_ - enemyNum_) - 50;

	double val = eval->density*(100+eval->aim)*(eval->speed+100)*(eval->tricky+100);
	if (val < 0) eval->difficulty = 0;
	else eval->difficulty = static_cast<int>(std::sqrt(std::sqrt(val))) - 50;

	return eval;
}

void InspectionCpu::report() const {
	std::auto_ptr<BulletEvaluation> eval(getReport().release());

	std::cout << "difficulty:\t" << eval->difficulty << std::endl;
	std::cout << "density:\t" << eval->density << std::endl;
	std::cout << "speed:\t" << eval->speed << std::endl;
	std::cout << "aim:\t" << eval->aim << std::endl;
	std::cout << "tricky:\t" << eval->tricky << std::endl;
}
