#include "human.h"

#include "game.h"
#include "conf.h"

HumanCpu::HumanCpu()
	: input_(Game::instance()->inputMgr()), remark_(false)
{
	name_ = "human";
}

void HumanCpu::calc() {
	remark_ = input_->getButton(0);

	MSDL::Axis axis = input_->getAxis();
	evaluations_[axis.getSmallAxisCode()] = 10;
}

int HumanCpu::getConfidence() const {
	if (remark_) return Conf::instance()->humanConfidence();
    else return 0;
}

