/**
 * $Id: cpuutil.cc,v 1.7 2003/10/13 22:54:41 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "cpu.h"

#include "util.h"
#include "conf.h"
#include "screen.h"

// utility

const Point CpuInputBase::axis2vec[] = {
	Point(0, 0), Point(0, -1), Point(1/SQRT_TWO, -1/SQRT_TWO), Point(1, 0),
	Point(1/SQRT_TWO, 1/SQRT_TWO), Point(0, 1),
	Point(-1/SQRT_TWO, 1/SQRT_TWO),
	Point(-1, 0), Point(-1/SQRT_TWO, -1/SQRT_TWO)};

Point CpuInputBase::getMovedPoint(const Point& pnt, MSDL::Axis axis) {
    double spf = info_->getSpf();

	double base = info_->getPlayerSpd() * spf;
	double cross = base / SQRT_TWO;

	Point ret;

	if (axis == MSDL::Axis::NONE) ret = pnt;
	else if (axis == MSDL::Axis::UP) ret = pnt + Point(0, -base);
	else if (axis == MSDL::Axis::UPRIGHT) ret = pnt + Point(cross, -cross);
	else if (axis == MSDL::Axis::RIGHT) ret = pnt + Point(base, 0);
	else if (axis == MSDL::Axis::DOWNRIGHT) ret = pnt + Point(cross, cross);
	else if (axis == MSDL::Axis::DOWN) ret = pnt + Point(0, base);
	else if (axis == MSDL::Axis::DOWNLEFT) ret = pnt + Point(-cross, cross);
	else if (axis == MSDL::Axis::LEFT) ret = pnt + Point(-base, 0);
	else if (axis == MSDL::Axis::UPLEFT) ret = pnt + Point(-cross, -cross);
	else throw std::runtime_error("unknow axis");

	static const Point upper(info_->getPlayerMaxPnt());

	if (ret.x > upper.x) {
		ret.x = upper.x;
	}
	else if (ret.x < 0) {
		ret.x = 0;
	}
	if (ret.y > upper.y) {
		ret.y = upper.y;
	}
	else if (ret.y < 0) {
		ret.y = 0;
	}

	return ret;
}

double CpuInputBase::getShotAngle(const PosSpd& shot) {
	const Point& pnt = info_->getPlayerPnt();

	return std::fabs(
		std::fabs(shot.second.angle()) -
		std::fabs(pnt.angle(shot.first)));

}

const std::string& CpuInputBase::getAxisString(MSDL::Axis axis) {
	static const std::string axis2str[] = {
		"Î~", "", "E", "E", "E", "", "", "", ""
	};

	return axis2str[axis.getSmallAxisCode()];
}

const Point& CpuInputBase::getAxisVector(MSDL::Axis axis) {
	return axis2vec[axis.getSmallAxisCode()];
}

