#ifndef BOHA_CPU
#define BOHA_CPU

#include "util.h"
#include "mysdl_padinput.h"
#include "cpuinfo.h"

#include <memory>
#include <string>

class CpuInputBase : public MSDL::InputBase {
protected:
	typedef std::pair<Point, Point> PosSpd;
    typedef std::vector<PosSpd> PosSpds;

public:
    CpuInputBase() : lastTurn_(-1), axis_(0) {}

	virtual ~CpuInputBase() {}

    virtual MSDL::Axis getAxis() {
		update();
		return axis_;
    }
    virtual bool getButton(int id) {
		update();
		return decision_ && id == 1;
	}

	static std::auto_ptr<CpuInputBase> getDefaultCpu();
	static void setCpuInfomation(std::auto_ptr<CpuInfo> info) {
		info_.reset(info.release());
	}

public:
	virtual void registShot(const PosSpd&) {}

	virtual void registEnemy(const class Enemy*) {}

	virtual int getAxisEvaluation(MSDL::Axis axis) {
		return evaluations_[axis.getSmallAxisCode()];
	}

	virtual int getConfidence() const { return 100; }

	virtual void report() const {}

public:
    void update();

public:
	const std::string& name() const { return name_; }

protected:
	void message(const std::string& msg);

private:
	virtual void calc() =0;

protected:
	void initEvaluation();

protected:
    int lastTurn_;
    int prevIndex_;

protected:
    MSDL::Axis axis_;
    bool decision_;

	int evaluations_[9];

	std::string name_;

protected:
	static std::auto_ptr<CpuInfo> info_;

protected:
	// utility

	Point getMovedPoint(const Point& pnt, MSDL::Axis axis);

	double getShotAngle(const PosSpd& shot);

	const std::string& getAxisString(MSDL::Axis axis);
	const Point& getAxisVector(MSDL::Axis axis);

	static const Point axis2vec[9];
};

#endif // ! BOHA_CPU
