/**
 * $Id: chairman.h,v 1.8 2003/10/13 22:54:41 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef leader_h_
#define leader_h_

#include "cpu.h"

#include <list>
#include <utility>
#include <memory>

#define MAX_DIETS 10

class Surface;

/// c
/**
 * cł鑼ASŸӌ܂Ƃ߂ĕj߂
 */
class ChairmanCpu : public CpuInputBase {
public:
    ChairmanCpu();
	~ChairmanCpu();

private:
	virtual void calc();

	virtual void registShot(const PosSpd& shot);
	virtual void registEnemy(const Enemy* enemy);

	virtual void report() const;

private:
	void drawGraph();
	void drawSingleGraph(int* evals, Color col);

private:
	std::vector<CpuInputBase*> diet_;

	int dietEvals_[MAX_DIETS][9];

	std::auto_ptr<Surface> surf_;

};


#endif // ! leader_h_

