#ifndef BOHA_CONF
#define BOHA_CONF

#include "singleton.h"
#include "util.h"

#include <string>
#include <map>
#include <cassert>

class Conf : public Singleton<Conf> {
public:
    Conf(int argc, char* argv[]);

	void reset();

    typedef std::map<int, std::string> IdToAct;
    typedef enum {SDMKUN, ACT, XML} HowToRun;

    const std::string& scoreFile() const { return scoreFile_; }
    const std::string& actionFile() const { return actionFile_; }
    void setActionFile(std::string file) { actionFile_ = file; }
    int enemys() const { return enemys_; }
    int verbose() const { return verbose_; }
    const std::string& command() const { return command_; }
    bool watch() const { return watch_; }
    const std::string& name() const { return name_; }
    const IdToAct& enemyActs() const { return enemyActs_; }
    const std::string& idToAct(int id) const {
		return enemyActs_.find(id)->second;
    }
    const IdToAct& globalActs() const { return globalActs_; }
    const std::string& idToGlobalAct(int id) const {
		return globalActs_.find(id)->second;
    }
    int firstGlobal() const { return firstGlobal_; }
    bool isFastMode() const { return fastMode_; }
    bool isFastQuit() const { return fastQuit_; }
    bool isProfiling() const { return profiling_; }
    bool isSlow() const { return isSlow_; }
    double slow() const { return slow_; }
    int level() const { return level_; }
    bool isCpu() const { return cpu_; }
	int density() const { return density_; }
	int timeLimit() const { return timeLimit_; }

    bool isDefault() const { return default_; }
    HowToRun gameType() const { return howToRun_; }

    void saveNameCache(const std::string& str) const;

	double playerSize() const { return playerSize_; }
	double playerSpeed() const { return playerSpeed_; }
	double playerSpeed2() const { return playerSpeed2_; }
	const Point& miniDispSize() const { return miniDispSize_; }
	const Point& normalDispSize() const { return normalDispSize_; }
	int fps() const { return fps_; }
	bool fullScreen() const { return fullScreen_; }
	bool dimmed() const { return dimmed_; }
	bool english() const { return english_; }
	bool preloadShots() const { return preloadShots_; }
	bool isNormalMode() const { return normal_; }
	bool sp() const { return sp_; }
	int mode() const { return mode_; }
	bool isReplay() const { return replay_; }
	const std::string& title() const { return title_; }
	int humanConfidence() const { return humanConfidence_; }
	std::string bmpdir() const { return "bmp/" + skin_; }

private:
    void loadName();
    void parseLongOption(const std::string& str) const;
    void help() const;
    void version() const;

	bool normal_;
    std::string scoreFile_;
    std::string actionFile_;
    int enemys_;
    int verbose_;
    std::string command_;
    bool watch_;
    std::string name_;
    IdToAct enemyActs_;
    IdToAct globalActs_;
    int firstGlobal_;
    bool fastMode_;
    bool fastQuit_;
    bool profiling_;
    bool isSlow_;
    double slow_;
    int level_;
    bool cpu_;
	int density_;
	double playerSize_;
	double playerSpeed_;
	double playerSpeed2_;
	Point miniDispSize_;
	Point normalDispSize_;
	int fps_;
	bool fullScreen_;
	bool dimmed_;
	bool english_;
	bool preloadShots_;
	int timeLimit_;
	int humanConfidence_;

	bool sp_;
	int mode_;
	bool replay_;
	std::string title_;

    bool default_;
    HowToRun howToRun_;

	std::string skin_;

    static const std::string nameCacheFile_;

	friend class Select;

};

#endif // BOHA_CONF
