#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "conf.h"
#include "util.h"

#include "bulletinfo.h"
#include "surface.h"

#include <sstream>
#include <iostream>
#include <fstream>

#include <cassert>

#ifdef BORLAND
# undef HAVE_UNISTD_H
# undef HAVE_GETOPT_H
#endif // BORLAND

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifdef HAVE_GETOPT_H
#include <getopt.h>
#endif

const std::string Conf::nameCacheFile_("name.cache");

void Conf::saveNameCache(const std::string& str) const {
    std::ofstream os(nameCacheFile_.c_str());
    os << str;
}

void Conf::loadName() {
	name_ = "SDM";
}

void Conf::parseLongOption(const std::string& str) const {
    if (str == "--help") {
		help();
    }
    else if (str == "--version") {
		version();
    }
}

void Conf::help() const {
    std::cerr << " sdmkun [OPTION] [CONFFILE]\n"
			  << "  Eȉ̃IvVIƃnCXRAɏ܂\n"
			  << "\t-e NUM \t G̐w肵܂\n"
			  << "\t-w     \t G[hɂȂ܂\n"
			  << "\t-d NUM \t ̔{ŃX[܂\n"
			  << "\t-l NUM \t 0100܂łw肵ăxݒł܂\n"
			  << "\t-c     \t Rs[^̃vC𒭂߂܂\n"
			  << "\t-t NUM \t w^[s܂\n"
			  << "  Eȉ̃IvV͑IĂnCXRAɏ܂\n"
			  << "\t-n NAME\t Ow肵܂\n"
			  << "\t-s FILE\t L^t@Cw肵܂\n"
			  << "\t-v NUM \t ȏNUM^[ɕ\܂\n"
			  << "\t-f     \t Vvȃ[hŋN܂\n"
			  << "\t-p     \t vt@CO܂\n"
			  << "\t-h     \t ̂փv\܂\n";
    exit(1);
}

void Conf::version() const {
    std::cout << "sdmkun version ?\n";
    exit(0);
}

void Conf::reset() {
    scoreFile_ = "dmkun.scr";
	actionFile_ = "bosses.act";
	enemys_ = 1;
	verbose_ = 0;
	watch_ = false;
	name_ = "";
	fastMode_ = false;
	fastQuit_ = false;
	profiling_ = false;
	isSlow_ = false;
	slow_ = 1;
	level_ = 50;
	cpu_ = false;
	density_ = 100;
	playerSize_ = 2;
	playerSpeed_ = 110 * 1.5;
	playerSpeed2_ = 55 * 1.5;
	miniDispSize_ = Point(300, 400);
	normalDispSize_ = Point(600, 450);
	fps_ = 60;
	fullScreen_ = false;
	dimmed_ = true;
	english_ = false;
	preloadShots_ = false;
	normal_ = false;
	sp_ = false;
	timeLimit_ = -1;
	humanConfidence_ = 100;
	skin_ = "default";

	default_ = true;
	howToRun_ = SDMKUN;
}

namespace {
	void copy_file(const std::string& ifile, const std::string& ofile) {
		std::ifstream is(ifile.c_str());
		std::ofstream os(ofile.c_str());
		while (1) {
			int c = is.get();
			if (c == -1) break;
			os.put(c);
		}
	}
}

Conf::Conf(int argc, char* argv[])
{
	reset();

    std::string extraOption = "";

#ifdef HAVE_UNISTD_H

    int optc;
    while ((optc = getopt(argc, argv, "l:a:d:e:s:hv:wn:fpct:")) != -1) {

	switch (optc) {
	case ('e'):
	    std::stringstream(optarg) >> enemys_;
	    check(enemys_ > 0, "Enemys are not here.");
	    default_ = false;
	    break;

	case ('d'):
	    std::stringstream(optarg) >> slow_;
	    check(slow_ > 0, "slow level can't be under zero.");
	    default_ = false;
	    isSlow_ = true;
	    break;

	case ('l'):
	    std::stringstream(optarg) >> level_;
	    check(level_ >= 0 && level_ <= 100, "level must be 0 to 100.");
	    default_ = false;
	    break;

	case ('s'):
	    scoreFile_ = std::string(optarg);
	    break;

	case ('v'):
	    std::stringstream(optarg) >> verbose_;
	    break;

	case ('w'):
	    watch_ = true;
	    default_ = false;
	    break;

	case ('c'):
	    cpu_ = true;
	    default_ = false;
	    break;

	case ('n'):
	    name_ = std::string(optarg);
	    break;

	case ('f'):
	    fastQuit_ = true;
	    fastMode_ = true;
	    break;

	case ('p'):
	    profiling_ = true;
	    break;

	case ('t'):
		std::stringstream(optarg) >> timeLimit_;
		default_ = false;
		break;

	case ('h'):
	{
	    help();
	}
	break;

	}
    }

    if (optind < argc) {
	extraOption = argv[optind];
    }
#else
    if (argc > 1) {
	extraOption = argv[1];
    }
#endif

    if (extraOption != "") {
		parseLongOption(extraOption);

		std::string foot = extraOption.substr(extraOption.find_last_of("."));
		if (foot == ".act") {	
			actionFile_ = extraOption;
			default_ = false;
			howToRun_ = ACT;
			fastMode_ = true;
		}
		else if (foot == ".xml" || foot == ".XML") {
			actionFile_ = extraOption;
			default_ = false;
			howToRun_ = XML;
			fastMode_ = true;
		}
		else if (foot == ".lua" || foot == ".LUA") {
			actionFile_ = extraOption;
			default_ = false;
			howToRun_ = XML;
			fastMode_ = true;
		}
		else if (foot == ".bml" || foot == ".BML") {
			default_ = false;
			howToRun_ = XML;
			fastMode_ = true;

#ifdef BORLAND
			size_t sepIndex = extraOption.find("\\");
			while (sepIndex != std::string::npos) {
				extraOption[sepIndex] = '/';
				sepIndex = extraOption.find("\\");
			}
#endif

			size_t slashIndex = extraOption.find_last_of("/");
			std::string file;
			if (slashIndex == std::string::npos) file = extraOption;
			else file = extraOption.substr(slashIndex+1);
			std::string bmlfile("user/" + file);

			if (bmlfile != extraOption) {
				std::cout
					<< "copy from '" << extraOption << "' to '"
					<< bmlfile << "'" << std::endl;
				copy_file(extraOption, "tmp.bml.tmp");
				std::rename("tmp.bml.tmp", bmlfile.c_str());
			}

			actionFile_ = bmlfile;
		}
		else {
			check(0, extraOption + ": can't understand.");
		}
    }

    if (name_ == "") loadName();
}

