/**
 * $Id: command_lua.h,v 1.3 2003/10/13 22:54:34 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef command_lua_h_
#define command_lua_h_

#include "command.h"

#include <string>

class EnemyCommandLua : public EnemyCommand {
public:
	EnemyCommandLua(std::string filename, class Enemy* enemy);
	EnemyCommandLua(std::string filename,
					const std::string& lua, class Enemy* enemy);
	EnemyCommandLua(struct lua_State* lua, const char* func,
					class Enemy* enemy, int id);
	virtual ~EnemyCommandLua();

public:
	virtual void run();
	virtual bool isCommandEnd() const;

public:
	void end() { end_ = true; }

public:
	void setPos(double x, double y) const;
	void setSpeed(double sx, double sy) const;
	void vanish() const;

	int getTurn() const { return turn_; }

private:
	void init();

private:
	struct lua_State* lua_;
	class Enemy* enemy_;
	std::string func_;
	int id_;

	bool end_;
	int turn_;
};

#endif // ! command_lua_h_

