/**
 * $Id: command_bulletml.h,v 1.2 2003/10/13 22:54:34 i Exp $
 *
 * Copyright (C) shinichiro.h <s31552@mail.ecc.u-tokyo.ac.jp>
 *  http://user.ecc.u-tokyo.ac.jp/~s31552/wp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef command_bulletml_h_
#define command_bulletml_h_

#include "command.h"

#include <bulletml/bulletmlrunner.h>

class Enemy;

class EnemyCommandBulletML : public BulletMLRunner, public EnemyCommand {
public:
	EnemyCommandBulletML(BulletMLParser* state, Enemy* enemy);
	EnemyCommandBulletML(BulletMLParser* state,
						 BulletMLNode* node, Enemy* enemy);
	EnemyCommandBulletML(BulletMLState* state, Enemy* enemy);

public:
	virtual void run() {
		BulletMLRunner::run();
	}
	virtual bool isCommandEnd() const {
		return BulletMLRunner::isEnd();
	}

protected:
	virtual double getBulletDirection();
	virtual double getAimDirection();
	virtual double getBulletSpeed();
	virtual double getDefaultSpeed();
	virtual double getRank();
	virtual void createSimpleBullet(double direction, double speed);
	virtual void createBullet(BulletMLState* state,
							  double direction, double speed);
	virtual int getTurn();
	virtual void doVanish();
	virtual void doChangeDirection(double direction);
	virtual void doChangeSpeed(double speed);
	virtual void doAccelX(double speedx);
	virtual void doAccelY(double speedy);
	virtual double getBulletSpeedX();
	virtual double getBulletSpeedY();

	virtual double getRand();

private:
	Enemy* enemy_;

};


#endif // ! command_bulletml_h_

