#include "command_bulletml.h"
#include "game.h"
#include "util.h"
#include "player.h"
#include "conf.h"
#include "replay.h"

#include <bulletml/bulletmlparser.h>

EnemyCommandBulletML::EnemyCommandBulletML(BulletMLParser* bulletml,
										   Enemy* enemy)
    : BulletMLRunner(bulletml), enemy_(enemy)
{
	std::cout << bulletml->getName() << " is next\n";
}

EnemyCommandBulletML::EnemyCommandBulletML(BulletMLState* state, Enemy* enemy)
    : BulletMLRunner(state), enemy_(enemy)
{}

double EnemyCommandBulletML::getBulletDirection() {
	return rtod(PolarCoord(enemy_->spd()).r);
}

double EnemyCommandBulletML::getAimDirection() {
	return rtod(Game::instance()->player()->center().angle(enemy_->center()));
}

double EnemyCommandBulletML::getBulletSpeed() {
	return PolarCoord(enemy_->spd()).l * 0.01;
}

double EnemyCommandBulletML::getDefaultSpeed() {
	return 1;
}

double EnemyCommandBulletML::getRank() {
	return Game::instance()->getRank();
}

void EnemyCommandBulletML::createSimpleBullet(double direction, double speed) {
	int d = Conf::instance()->density();
	if (d != 100) {
		if (rnd(100) >= d) return;
	}

	Game::instance()->addShot(enemy_->center(),
							  Point(PolarCoord(speed*100, dtor(direction))),
							  enemy_);
}

void EnemyCommandBulletML::createBullet(BulletMLState* state,
								double direction, double speed) {
	int d = Conf::instance()->density();
	if (d != 100) {
		if (rnd(100) >= d) return;
	}

	Game::instance()->addEnemy(enemy_->center(),
							   Point(PolarCoord(speed*100, dtor(direction))),
							   state, enemy_);
}

int EnemyCommandBulletML::getTurn() {
	return static_cast<int>(Game::instance()->getFrameTurn());
}

void EnemyCommandBulletML::doVanish() {
	enemy_->alive_ = false;
}

void EnemyCommandBulletML::doChangeDirection(double direction) {
	PolarCoord pc;
	pc.l = enemy_->spd().length();
	// ۑ邽߂̃AhzbNȉ
	if (pc.l == 0.0) pc.l = 0.00001;
	pc.r = dtor(direction);
	enemy_->spd_ = Point(pc);
}

void EnemyCommandBulletML::doChangeSpeed(double speed) {
	PolarCoord  pc(enemy_->spd());
	pc.l = speed * 100.0;
	enemy_->spd_ = Point(pc);
}

void EnemyCommandBulletML::doAccelX(double speedx) {
	enemy_->spd_.x = speedx * 100;
}

void EnemyCommandBulletML::doAccelY(double speedy) {
	enemy_->spd_.y = speedy * 100;
}

double EnemyCommandBulletML::getBulletSpeedX() {
	return enemy_->spd_.x * 0.01;
}

double EnemyCommandBulletML::getBulletSpeedY() {
	return enemy_->spd_.y * 0.01;
}

double EnemyCommandBulletML::getRand() {
	return rep_rec_rand();
}
