#ifndef BOHA_CHAR
#define BOHA_CHAR

#include "util.h"
#include "surface.h"
#include "screen.h"

#include <memory>

class Player;
class Enemy;
class Shot;

class Charactor {
public:
    // _ufBXpb`
    virtual void hit (Charactor*) = 0;
    virtual void hitByPlayer (Player*) {};
    virtual void hitByEnemy (Enemy*) {};
    virtual void hitByShot (Shot*) {};

    bool isHit(const Charactor* bc) const {
		int diffx = std::abs(center_.xi() - bc->center().xi());
		if (diffx > 20) return false;
		int diffy = std::abs(center_.yi() - bc->center().yi());
		if (diffy > 20) return false;
		return true;
	}

    virtual void wallEvent();

    Charactor (const Point& pnt, Surface* graph);
    virtual ~Charactor();

    const Point& pnt() const { return pnt_; }
    const Point& spd() const { return spd_; }
    virtual const Point& size() const { return graph_->size(); }
    const bool alive() const { return alive_; }

    const Point& center() const {
		return center_;
    }

    void moveValue();
    void moveGraphic () const;

protected:
	void calcCenter() {
		center_ = pnt_ + Point(graph_->size().xi()>>1, graph_->size().yi()>>1);
	}

    Charactor();

    Point pnt_, spd_, center_;

	Surface* graph_;
    bool alive_;

    Surface* surface_;

    // ʂôH
    bool zako_;

	int turn_;
};

#endif // BOHA_CHAR

