#include "char.h"
#include "game.h"
#include "conf.h"

#include <cmath>
#include <iostream>

void Charactor::wallEvent() {
	if (zako_) {
		const Point& ms = surface_->size();

		if (center().x > ms.x || center().x < 0 ||
			center().y > ms.y || center().y < 0)
			alive_ = false;
	}

	else {
		static const Point& ms = surface_->size();
		static const Point& cs = graph_->size();
		static const Point upper(ms.x-cs.x, ms.y-cs.y);

		if (pnt_.x > upper.x) {
			pnt_.x = upper.x;
			calcCenter();
		}
		else if (pnt_.x < 0) {
			pnt_.x = 0;
			calcCenter();
		}
		if (pnt_.y > upper.y) {
			pnt_.y = upper.y;
			calcCenter();
		}
		else if (pnt_.y < 0) {
			pnt_.y = 0;
			calcCenter();
		}
	}
}

Charactor::Charactor (const Point& pnt, Surface* graph)
	: spd_(Point(0, 0)), 
	  graph_(graph), alive_(true), surface_(Game::instance()->mainFrame()),
      turn_(0)
{
	pnt_ = pnt - graph_->size()/2;
	calcCenter();
}

Charactor::~Charactor() {
}

void Charactor::moveValue() {
	turn_++;
	pnt_ += spd_ * Game::instance()->spf();
	calcCenter();
}

void Charactor::moveGraphic() const {
	if (1) {
		surface_->blit(graph_, pnt_);
	}
	else if (0) {
		graph_->setAlpha(SDL_SRCALPHA,
						 (int)(200+50*std::sin(0.1*turn_)));
		surface_->blit(graph_, pnt_);
	}
	else if (0) {
	}
	else {
		static const int randomLineSeed[12][2] = {
			{1, 1}, {1, 0}, {1, -1},
			{0, 1}, {0, -1},
			{-1, 1}, {-1, 0}, {-1, 1},
			{2, 0}, {0, 2}, {-2, 0}, {0, -2}
		};

		static struct PseudoRandom {
			int p;
			bool b;
			PseudoRandom() : p(0), b(false) {}
			int gen() {
				b ^= 1;
				if (b) {
					p++;
					if (p == 12) p = 0;
					return randomLineSeed[p][0];
				}
				else {
					return randomLineSeed[p][1];
				}
			}
		} pr;

		Point prev(pnt_-spd_*0.16);
		surface_->drawLine(prev.xi(), prev.yi(), pnt_.xi(), pnt_.yi(), Color::WHITE);
		surface_->drawLine(prev.xi()+pr.gen(), prev.yi()+pr.gen(), pnt_.xi(), pnt_.yi(),
						   Color(180, 180, 255));
		surface_->drawLine(prev.xi()+pr.gen(), prev.yi()+pr.gen(), pnt_.xi(), pnt_.yi(),
						   Color(180, 180, 255));
	}
}

