package jp.gr.java_conf.abagames.bulletml;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>FireElm</b> is generated by Relaxer based on bulletml.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <hedgeRule label="fireElm">
 *   <choice>
 *     <ref label="fire"/>
 *     <ref label="fireRef"/>
 *   </choice>
 * </hedgeRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;hedgeRule label="fireElm"&gt;
 *   &lt;choice&gt;
 *     &lt;ref label="fire"/&gt;
 *     &lt;ref label="fireRef"/&gt;
 *   &lt;/choice&gt;
 * &lt;/hedgeRule&gt;
 * </pre>
 *
 * @version bulletml.rlx 0.21 (Sun Jun 03 09:44:34 JST 2001)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class FireElm implements java.io.Serializable, IRNSContainer, IRNode, IActionChoice {
    private RNSContext rNSContext_ = new RNSContext(this);
    private IFireElmChoice content_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>FireElm</code>.
     *
     */
    public FireElm() {
    }

    /**
     * Creates a <code>FireElm</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public FireElm(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>FireElm</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        if (Fire.isMatch(stack)) {
            setContent(new Fire(stack));
        } else if (FireRef.isMatch(stack)) {
            setContent(new FireRef(stack));
        } else {
            throw (new IllegalArgumentException());
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        this.content_.makeElement(element);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the IFireElmChoice property <b>content</b>.
     *
     * @return IFireElmChoice
     */
    public final IFireElmChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IFireElmChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IFireElmChoice content) {
        this.content_ = content;
        if (content != null) {
            content.setParentRNode(this);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        content_.makeTextElement(buffer);
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        content_.makeTextElement(buffer);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.add(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FireElm</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>FireElm</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack;
        Element child;
        if (Fire.isMatchHungry(target)) {
        } else if (FireRef.isMatchHungry(target)) {
        } else {
            return (false);
        }
        return (true);
    }
}
