package jp.gr.java_conf.abagames.bulletml;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>Bulletml</b> is generated by Relaxer based on bulletml.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <elementRule role="bulletml">
 *   <choice occurs="*">
 *     <ref label="action"/>
 *     <ref label="bullet"/>
 *     <ref label="fire"/>
 *   </choice>
 * </elementRule>
 * 
 * <tag name="bulletml">
 *   <attribute name="xmlns" type="string"/>
 *   <attribute name="type" type="string">
 *     <enumeration value="none"/>
 *     <enumeration value="vertical"/>
 *     <enumeration value="horizontal"/>
 *   </attribute>
 * </tag>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;elementRule role="bulletml"&gt;
 *   &lt;choice occurs="*"&gt;
 *     &lt;ref label="action"/&gt;
 *     &lt;ref label="bullet"/&gt;
 *     &lt;ref label="fire"/&gt;
 *   &lt;/choice&gt;
 * &lt;/elementRule&gt;
 * &lt;tag name="bulletml"&gt;
 *   &lt;attribute name="xmlns" type="string"/&gt;
 *   &lt;attribute name="type" type="string"&gt;
 *     &lt;enumeration value="none"/&gt;
 *     &lt;enumeration value="vertical"/&gt;
 *     &lt;enumeration value="horizontal"/&gt;
 *   &lt;/attribute&gt;
 * &lt;/tag&gt;
 * </pre>
 *
 * @version bulletml.rlx 0.21 (Sun Jun 03 09:44:34 JST 2001)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class Bulletml implements java.io.Serializable, IRNSContainer, IRNode {
    private RNSContext rNSContext_ = new RNSContext(this);
    private String xmlns_;
    private String type_;
    // List<IBulletmlChoice>
    private java.util.List content_ = new java.util.ArrayList();
    private IRNode parentRNode_;

    /**
     * Creates a <code>Bulletml</code>.
     *
     */
    public Bulletml() {
    }

    /**
     * Creates a <code>Bulletml</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Bulletml(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Bulletml</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Bulletml(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Bulletml</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Bulletml(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Bulletml</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Bulletml</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Bulletml</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Bulletml</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Bulletml</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Bulletml</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Bulletml(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Bulletml</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Bulletml</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Bulletml</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        setup(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        rNSContext_.declareNamespace(element);
        xmlns_ = URelaxer.getAttributePropertyAsString(element, "xmlns");
        type_ = URelaxer.getAttributePropertyAsString(element, "type");
        content_.clear();
        while (!stack.isEmptyElement()) {
            if (Action.isMatch(stack)) {
                addContent(new Action(stack));
            } else if (Bullet.isMatch(stack)) {
                addContent(new Bullet(stack));
            } else if (Fire.isMatch(stack)) {
                addContent(new Fire(stack));
            } else {
                break;
            }
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElementNS("http://www.asahi-net.or.jp/~cs8k-cyu/bulletml", "bulletml");
        rNSContext_.setupNamespace(element);
        int size;
        if (this.xmlns_ != null) {
            URelaxer.setAttributePropertyByString(element, "xmlns", this.xmlns_);
        }
        if (this.type_ != null) {
            URelaxer.setAttributePropertyByString(element, "type", this.type_);
        }
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Bulletml</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Bulletml</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(uri));
    }

    /**
     * Initializes the <code>Bulletml</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(url));
    }

    /**
     * Initializes the <code>Bulletml</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(in));
    }

    /**
     * Initializes the <code>Bulletml</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(is));
    }

    /**
     * Initializes the <code>Bulletml</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getValidDocument(reader));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the String property <b>xmlns</b>.
     *
     * @return String
     */
    public final String getXmlns() {
        return (xmlns_);
    }

    /**
     * Sets the String property <b>xmlns</b>.
     *
     * @param xmlns
     */
    public final void setXmlns(String xmlns) {
        this.xmlns_ = xmlns;
    }

    /**
     * Gets the String property <b>type</b>.
     *
     * @return String
     */
    public final String getType() {
        return (type_);
    }

    /**
     * Sets the String property <b>type</b>.
     *
     * @param type
     */
    public final void setType(String type) {
        this.type_ = type;
    }

    /**
     * Gets the IBulletmlChoice property <b>content</b>.
     *
     * @return IBulletmlChoice[]
     */
    public final IBulletmlChoice[] getContent() {
        IBulletmlChoice[] array = new IBulletmlChoice[content_.size()];
        return ((IBulletmlChoice[])content_.toArray(array));
    }

    /**
     * Sets the IBulletmlChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IBulletmlChoice[] content) {
        this.content_.clear();
        this.content_.addAll(java.util.Arrays.asList(content));
        for (int i = 0;i < content.length;i++) {
            content[i].setParentRNode(this);
        }
    }

    /**
     * Sets the IBulletmlChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IBulletmlChoice content) {
        this.content_.clear();
        this.content_.add(content);
        if (content != null) {
            content.setParentRNode(this);
        }
    }

    /**
     * Adds the IBulletmlChoice property <b>content</b>.
     *
     * @param content
     */
    public final void addContent(IBulletmlChoice content) {
        this.content_.add(content);
        if (content != null) {
            content.setParentRNode(this);
        }
    }

    /**
     * Gets number of the IBulletmlChoice property <b>content</b>.
     *
     * @return int
     */
    public final int getContentCount() {
        return (content_.size());
    }

    /**
     * Gets the IBulletmlChoice property <b>content</b> by index.
     *
     * @param index
     * @return IBulletmlChoice
     */
    public final IBulletmlChoice getContent(int index) {
        return ((IBulletmlChoice)content_.get(index));
    }

    /**
     * Sets the IBulletmlChoice property <b>content</b> by index.
     *
     * @param index
     * @param content
     */
    public final void setContent(int index, IBulletmlChoice content) {
        this.content_.set(index, content);
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://www.asahi-net.or.jp/~cs8k-cyu/bulletml");
        buffer.append("<");
        URelaxer.makeQName(prefix, "bulletml", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (xmlns_ != null) {
            buffer.append(" ");
        buffer.append("xmlns");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(getXmlns()));
            buffer.append("\"");
        }
        if (type_ != null) {
            buffer.append(" ");
        buffer.append("type");
            buffer.append("=\"");
            buffer.append(URelaxer.escapeAttrQuot(getType()));
            buffer.append("\"");
        }
        buffer.append(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.append("</");
        URelaxer.makeQName(prefix, "bulletml", buffer);
        buffer.append(">");
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        String prefix = rNSContext_.getPrefixByUri("http://www.asahi-net.or.jp/~cs8k-cyu/bulletml");
        buffer.print("<");
        URelaxer.makeQName(prefix, "bulletml", buffer);
        rNSContext_.makeNSMappings(buffer);
        if (xmlns_ != null) {
            buffer.print(" ");
        buffer.print("xmlns");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(getXmlns()));
            buffer.print("\"");
        }
        if (type_ != null) {
            buffer.print(" ");
        buffer.print("type");
            buffer.print("=\"");
            buffer.print(URelaxer.escapeAttrQuot(getType()));
            buffer.print("\"");
        }
        buffer.print(">");
        size = this.content_.size();
        for (int i = 0;i < size;i++) {
            IBulletmlChoice value = (IBulletmlChoice)this.content_.get(i);
            value.makeTextElement(buffer);
        }
        buffer.print("</");
        URelaxer.makeQName(prefix, "bulletml", buffer);
        buffer.print(">");
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.addAll(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Bulletml</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer2.isTargetElement(element, "http://www.asahi-net.or.jp/~cs8k-cyu/bulletml", "bulletml")) {
            return (false);
        }
        RStack target = new RStack(element);
        Element child;
        while (!target.isEmptyElement()) {
            if (Action.isMatchHungry(target)) {
            } else if (Bullet.isMatchHungry(target)) {
            } else if (Fire.isMatchHungry(target)) {
            } else {
                break;
            }
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Bulletml</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Bulletml</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
