package jp.gr.java_conf.abagames.bulletml;

import java.io.*;
import java.net.URL;
import java.net.MalformedURLException;
import javax.xml.parsers.*;
import org.xml.sax.*;
import org.w3c.dom.*;

/**
 * <b>ActionElm</b> is generated by Relaxer based on bulletml.rlx.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <hedgeRule label="actionElm">
 *   <choice>
 *     <ref label="action"/>
 *     <ref label="actionRef"/>
 *   </choice>
 * </hedgeRule>
 * -->
 * <!-- for javadoc -->
 * <pre> &lt;hedgeRule label="actionElm"&gt;
 *   &lt;choice&gt;
 *     &lt;ref label="action"/&gt;
 *     &lt;ref label="actionRef"/&gt;
 *   &lt;/choice&gt;
 * &lt;/hedgeRule&gt;
 * </pre>
 *
 * @version bulletml.rlx 0.21 (Sun Jun 03 09:44:34 JST 2001)
 * @author  Relaxer 0.13 (http://www.relaxer.org)
 */
public class ActionElm implements java.io.Serializable, IRNSContainer, IRNode, IActionChoice {
    private RNSContext rNSContext_ = new RNSContext(this);
    private IActionElmChoice content_;
    private IRNode parentRNode_;

    /**
     * Creates a <code>ActionElm</code>.
     *
     */
    public ActionElm() {
    }

    /**
     * Creates a <code>ActionElm</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ActionElm(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>ActionElm</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        if (Action.isMatch(stack)) {
            setContent(new Action(stack));
        } else if (ActionRef.isMatch(stack)) {
            setContent(new ActionRef(stack));
        } else {
            throw (new IllegalArgumentException());
        }
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        this.content_.makeElement(element);
    }

    /**
     * Gets the RNSContext property <b>rNSContext</b>.
     *
     * @return RNSContext
     */
    public final RNSContext getRNSContext() {
        return (rNSContext_);
    }

    /**
     * Sets the RNSContext property <b>rNSContext</b>.
     *
     * @param rNSContext
     */
    public final void setRNSContext(RNSContext rNSContext) {
        this.rNSContext_ = rNSContext;
    }

    /**
     * Gets the IActionElmChoice property <b>content</b>.
     *
     * @return IActionElmChoice
     */
    public final IActionElmChoice getContent() {
        return (content_);
    }

    /**
     * Sets the IActionElmChoice property <b>content</b>.
     *
     * @param content
     */
    public final void setContent(IActionElmChoice content) {
        this.content_ = content;
        if (content != null) {
            content.setParentRNode(this);
        }
    }

    /**
     * Makes a XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        content_.makeTextElement(buffer);
    }

    /**
     * Makes a XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        content_.makeTextElement(buffer);
    }

    /**
     * Gets the IRNode property <b>parentRNode</b>.
     *
     * @return IRNode
     */
    public final IRNode getParentRNode() {
        return (parentRNode_);
    }

    /**
     * Sets the IRNode property <b>parentRNode</b>.
     *
     * @param parentRNode
     */
    public final void setParentRNode(IRNode parentRNode) {
        this.parentRNode_ = parentRNode;
    }

    /**
     * Gets child RNodes.
     *
     * @return IRNode[]
     */
    public IRNode[] getRNodes() {
        java.util.List classNodes = new java.util.ArrayList();
        classNodes.add(content_);
        IRNode[] nodes = new IRNode[classNodes.size()];
        return ((IRNode[])classNodes.toArray(nodes));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ActionElm</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ActionElm</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack;
        Element child;
        if (Action.isMatchHungry(target)) {
        } else if (ActionRef.isMatchHungry(target)) {
        } else {
            return (false);
        }
        return (true);
    }
}
